/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.ForHiveMetastore;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveMetastoreClient;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.CachingHiveMetastoreStats;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.shaded.org.apache.thrift.TException;
import com.facebook.presto.hive.util.BackgroundCacheLoader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    private final CachingHiveMetastoreStats stats = new CachingHiveMetastoreStats();
    protected final HiveCluster clientProvider;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<String, Database> databaseCache;
    private final LoadingCache<String, List<String>> tableNamesCache;
    private final LoadingCache<String, List<String>> viewNamesCache;
    private final LoadingCache<HiveTableName, List<String>> partitionNamesCache;
    private final LoadingCache<HiveTableName, Table> tableCache;
    private final LoadingCache<HivePartitionName, Partition> partitionCache;
    private final LoadingCache<PartitionFilter, List<String>> partitionFilterCache;

    @Inject
    public CachingHiveMetastore(HiveCluster hiveCluster, @ForHiveMetastore ExecutorService executor, HiveClientConfig hiveClientConfig) {
        this((HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null"), (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null"), ((HiveClientConfig)Preconditions.checkNotNull((Object)hiveClientConfig, (Object)"hiveClientConfig is null")).getMetastoreCacheTtl(), hiveClientConfig.getMetastoreRefreshInterval());
    }

    public CachingHiveMetastore(HiveCluster hiveCluster, ExecutorService executor, Duration cacheTtl, Duration refreshInterval) {
        this.clientProvider = (HiveCluster)Preconditions.checkNotNull((Object)hiveCluster, (Object)"hiveCluster is null");
        long expiresAfterWriteMillis = ((Duration)Preconditions.checkNotNull((Object)cacheTtl, (Object)"cacheTtl is null")).toMillis();
        long refreshMills = ((Duration)Preconditions.checkNotNull((Object)refreshInterval, (Object)"refreshInterval is null")).toMillis();
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.databaseNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String key) throws Exception {
                return CachingHiveMetastore.this.loadAllDatabases();
            }
        });
        this.databaseCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, Database>(listeningExecutor){

            public Database load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadDatabase(databaseName);
            }
        });
        this.tableNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllTables(databaseName);
            }
        });
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HiveTableName, Table>(listeningExecutor){

            public Table load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadTable(hiveTableName);
            }
        });
        this.viewNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<String, List<String>>(listeningExecutor){

            public List<String> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllViews(databaseName);
            }
        });
        this.partitionNamesCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HiveTableName, List<String>>(listeningExecutor){

            public List<String> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNames(hiveTableName);
            }
        });
        this.partitionFilterCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<PartitionFilter, List<String>>(listeningExecutor){

            public List<String> load(PartitionFilter partitionFilter) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNamesByParts(partitionFilter);
            }
        });
        this.partitionCache = CacheBuilder.newBuilder().expireAfterWrite(expiresAfterWriteMillis, TimeUnit.MILLISECONDS).refreshAfterWrite(refreshMills, TimeUnit.MILLISECONDS).build((CacheLoader)new BackgroundCacheLoader<HivePartitionName, Partition>(listeningExecutor){

            public Partition load(HivePartitionName partitionName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<HivePartitionName, Partition> loadAll(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        });
    }

    @Managed
    @Flatten
    public CachingHiveMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
    }

    private static <K, V, E extends Exception> V get(LoadingCache<K, V> cache, K key, Class<E> exceptionClass) throws E {
        try {
            return (V)cache.get(key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static <K, V, E extends Exception> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys, Class<E> exceptionClass) throws E {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)t, exceptionClass);
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "", RuntimeException.class);
    }

    private List<String> loadAllDatabases() throws Exception {
        try {
            return RetryDriver.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List list = client.get_all_databases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Database getDatabase(String databaseName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.databaseCache, databaseName, NoSuchObjectException.class);
    }

    private Database loadDatabase(String databaseName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Database database = client.get_database(databaseName);
                    return database;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getAllTables(String databaseName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName, NoSuchObjectException.class);
    }

    private List<String> loadAllTables(String databaseName) throws Exception {
        Callable<List> getAllTables = this.stats.getGetAllTables().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List list = client.get_all_tables(databaseName);
                return list;
            }
        });
        Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                client.get_database(databaseName);
                Void void_ = null;
                return void_;
            }
        });
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                List tables = (List)getAllTables.call();
                if (tables.isEmpty()) {
                    getDatabase.call();
                }
                return tables;
            });
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Table getTable(String databaseName, String tableName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.table(databaseName, tableName), NoSuchObjectException.class);
    }

    @Override
    public List<String> getAllViews(String databaseName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName, NoSuchObjectException.class);
    }

    private List<String> loadAllViews(String databaseName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getAllViews().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    String filter = "hive_filter_field_params__presto_view = \"true\"";
                    List list = client.get_table_names_by_filter(databaseName, filter, (short)-1);
                    return list;
                }
            }));
        }
        catch (UnknownDBException e) {
            throw new NoSuchObjectException(e.getMessage());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public void createTable(Table table) {
        try {
            RetryDriver.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.create_table(table);
                }
                this.tableNamesCache.invalidate((Object)table.getDbName());
                this.viewNamesCache.invalidate((Object)table.getDbName());
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (InvalidObjectException | MetaException | NoSuchObjectException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName) {
        try {
            RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.drop_table(databaseName, tableName, true);
                }
                this.tableCache.invalidate((Object)new HiveTableName(databaseName, tableName));
                this.tableNamesCache.invalidate((Object)databaseName);
                this.viewNamesCache.invalidate((Object)databaseName);
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            RetryDriver.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("renameTable", this.stats.getRenameTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Table table = new Table(this.loadTable(new HiveTableName(databaseName, tableName)));
                    table.setDbName(newDatabaseName);
                    table.setTableName(newTableName);
                    client.alter_table(databaseName, tableName, table);
                }
                this.tableCache.invalidate((Object)new HiveTableName(databaseName, tableName));
                this.tableNamesCache.invalidate((Object)databaseName);
                this.viewNamesCache.invalidate((Object)databaseName);
                return null;
            }));
        }
        catch (InvalidOperationException | MetaException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Table loadTable(HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Table table = client.get_table(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
                    if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !HiveUtil.isPrestoView(table)) {
                        throw new HiveViewNotSupportedException(new SchemaTableName(hiveTableName.getDatabaseName(), hiveTableName.getTableName()));
                    }
                    Table table2 = table;
                    return table2;
                }
            }));
        }
        catch (HiveViewNotSupportedException | NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getPartitionNames(String databaseName, String tableName) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.partitionNamesCache, HiveTableName.table(databaseName, tableName), NoSuchObjectException.class);
    }

    private List<String> loadPartitionNames(HiveTableName hiveTableName) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List list = client.get_partition_names(hiveTableName.getDatabaseName(), hiveTableName.getTableName(), (short)0);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public List<String> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) throws NoSuchObjectException {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, parts), NoSuchObjectException.class);
    }

    private List<String> loadPartitionNamesByParts(PartitionFilter partitionFilter) throws Exception {
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List list = client.get_partition_names_ps(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getParts(), (short)-1);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public Map<String, Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException {
        Iterable names = Iterables.transform(partitionNames, name -> HivePartitionName.partition(databaseName, tableName, name));
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        Map<HivePartitionName, Partition> all = CachingHiveMetastore.getAll(this.partitionCache, names, NoSuchObjectException.class);
        for (Map.Entry<HivePartitionName, Partition> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getPartitionName(), (Object)entry.getValue());
        }
        return partitionsByName.build();
    }

    private Partition loadPartitionByName(HivePartitionName partitionName) throws Exception {
        Preconditions.checkNotNull((Object)partitionName, (Object)"partitionName is null");
        try {
            return RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionByName().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Partition partition = client.get_partition_by_name(partitionName.getHiveTableName().getDatabaseName(), partitionName.getHiveTableName().getTableName(), partitionName.getPartitionName());
                    return partition;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private Map<HivePartitionName, Partition> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
        Preconditions.checkNotNull(partitionNames, (Object)"partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        HivePartitionName firstPartition = (HivePartitionName)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument((boolean)hivePartitionName.getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object[])new Object[]{hiveTableName, hivePartitionName.getHiveTableName()});
            partitionsToFetch.add(hivePartitionName.getPartitionName());
        }
        ImmutableList partitionColumnNames = ImmutableList.copyOf(Warehouse.makeSpecFromName((String)firstPartition.getPartitionName()).keySet());
        try {
            return (Map)RetryDriver.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> this.lambda$loadPartitionsByNames$22(databaseName, tableName, partitionsToFetch, (List)partitionColumnNames)));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw noSuchObjectException;
        }
        catch (TException tException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)tException);
        }
    }

    private /* synthetic */ ImmutableMap lambda$loadPartitionsByNames$22(String string, String string2, List list, List list2) throws Exception {
        try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
            ImmutableMap.Builder partitions = ImmutableMap.builder();
            for (Partition partition : client.get_partitions_by_names(string, string2, list)) {
                String partitionId = FileUtils.makePartName((List)list2, (List)partition.getValues(), null);
                partitions.put((Object)HivePartitionName.partition(string, string2, partitionId), (Object)partition);
            }
            ImmutableMap immutableMap = partitions.build();
            return immutableMap;
        }
    }

    private static class PartitionFilter {
        private final HiveTableName hiveTableName;
        private final List<String> parts;

        private PartitionFilter(HiveTableName hiveTableName, List<String> parts) {
            this.hiveTableName = hiveTableName;
            this.parts = ImmutableList.copyOf(parts);
        }

        public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> parts) {
            return new PartitionFilter(HiveTableName.table(databaseName, tableName), parts);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("parts", this.parts).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFilter that = (PartitionFilter)o;
            return Objects.equal((Object)this.hiveTableName, (Object)that.hiveTableName) && Objects.equal(this.parts, that.parts);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.hiveTableName, this.parts});
        }
    }

    private static class HivePartitionName {
        private final HiveTableName hiveTableName;
        private final String partitionName;

        private HivePartitionName(HiveTableName hiveTableName, String partitionName) {
            this.hiveTableName = hiveTableName;
            this.partitionName = partitionName;
        }

        public static HivePartitionName partition(String databaseName, String tableName, String partitionName) {
            return new HivePartitionName(HiveTableName.table(databaseName, tableName), partitionName);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("hiveTableName", (Object)this.hiveTableName).add("partitionName", (Object)this.partitionName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HivePartitionName that = (HivePartitionName)o;
            return Objects.equal((Object)this.hiveTableName, (Object)that.hiveTableName) && Objects.equal((Object)this.partitionName, (Object)that.partitionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.hiveTableName, this.partitionName});
        }
    }

    private static class HiveTableName {
        private final String databaseName;
        private final String tableName;

        private HiveTableName(String databaseName, String tableName) {
            this.databaseName = databaseName;
            this.tableName = tableName;
        }

        public static HiveTableName table(String databaseName, String tableName) {
            return new HiveTableName(databaseName, tableName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("databaseName", (Object)this.databaseName).add("tableName", (Object)this.tableName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveTableName that = (HiveTableName)o;
            return Objects.equal((Object)this.databaseName, (Object)that.databaseName) && Objects.equal((Object)this.tableName, (Object)that.tableName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.databaseName, this.tableName});
        }
    }
}

