/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveRecordCursor;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.hive.util.Types;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUtil;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class OrcHiveRecordCursor
extends HiveRecordCursor {
    private final RecordReader recordReader;
    private final DateTimeZone sessionTimeZone;
    private final String[] names;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final ObjectInspector[] fieldInspectors;
    private final int[] hiveColumnIndexes;
    private final boolean[] isPartitionColumn;
    private OrcStruct row;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final boolean[] nulls;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;
    private final long timeZoneCorrection;

    public OrcHiveRecordCursor(RecordReader recordReader, long totalBytes, Properties splitSchema, List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, DateTimeZone sessionTimeZone, TypeManager typeManager) {
        Preconditions.checkNotNull((Object)recordReader, (Object)"recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Preconditions.checkNotNull((Object)splitSchema, (Object)"splitSchema is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkNotNull((Object)hiveStorageTimeZone, (Object)"hiveStorageTimeZone is null");
        Preconditions.checkNotNull((Object)sessionTimeZone, (Object)"sessionTimeZone is null");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.sessionTimeZone = sessionTimeZone;
        int size = columns.size();
        this.names = new String[size];
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.hiveColumnIndexes = new int[size];
        this.isPartitionColumn = new boolean[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.nulls = new boolean[size];
        long hiveStorageCorrection = new DateTime(2015, 1, 1, 0, 0, hiveStorageTimeZone).getMillis() - new DateTime(2015, 1, 1, 0, 0, DateTimeZone.UTC).getMillis();
        long jvmCorrection = new DateTime(2015, 1, 1, 0, 0).getMillis() - new DateTime(2015, 1, 1, 0, 0, DateTimeZone.UTC).getMillis();
        this.timeZoneCorrection = hiveStorageCorrection - jvmCorrection;
        StructObjectInspector rowInspector = HiveUtil.getTableObjectInspector(splitSchema);
        for (int i = 0; i < columns.size(); ++i) {
            HiveColumnHandle column = columns.get(i);
            this.names[i] = column.getName();
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            if (!column.isPartitionKey()) {
                this.fieldInspectors[i] = rowInspector.getStructFieldRef(column.getName()).getFieldObjectInspector();
            }
            this.hiveColumnIndexes[i] = column.getHiveColumnIndex();
            this.isPartitionColumn[i] = column.isPartitionKey();
        }
        ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            if (!column.isPartitionKey()) continue;
            HivePartitionKey partitionKey = (HivePartitionKey)partitionKeysByName.get(column.getName());
            Preconditions.checkArgument((partitionKey != null ? 1 : 0) != 0, (String)"Unknown partition key %s", (Object[])new Object[]{column.getName()});
            byte[] bytes = partitionKey.getValue().getBytes(StandardCharsets.UTF_8);
            String name = this.names[columnIndex];
            Type type = this.types[columnIndex];
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(BigintType.BIGINT)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(DoubleType.DOUBLE)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                this.slices[columnIndex] = Slices.wrappedBuffer((byte[])bytes);
                continue;
            }
            if (type.equals(DateType.DATE)) {
                this.longs[columnIndex] = HiveUtil.datePartitionKey(partitionKey.getValue(), name);
                continue;
            }
            if (type.equals(TimestampType.TIMESTAMP)) {
                this.longs[columnIndex] = HiveUtil.timestampPartitionKey(partitionKey.getValue(), hiveStorageTimeZone, name);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for partition key: %s", type.getDisplayName(), name));
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.hasNext()) {
                this.close();
                return false;
            }
            this.row = (OrcStruct)this.recordReader.next((Object)this.row);
            System.arraycopy(this.isPartitionColumn, 0, this.loaded, 0, this.isPartitionColumn.length);
            return true;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object object = OrcUtil.getFieldValue(this.row, this.hiveColumnIndexes[column]);
        if (object == null) {
            this.nulls[column] = true;
        } else {
            this.nulls[column] = false;
            this.booleans[column] = ((BooleanWritable)object).get();
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object object = OrcUtil.getFieldValue(this.row, this.hiveColumnIndexes[column]);
        if (object == null) {
            this.nulls[column] = true;
        } else {
            this.nulls[column] = false;
            HiveType type = this.hiveTypes[column];
            if (this.hiveTypes[column].equals(HiveType.HIVE_SHORT)) {
                ShortWritable shortWritable = (ShortWritable)object;
                this.longs[column] = shortWritable.get();
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_DATE)) {
                this.longs[column] = ((DateWritable)object).getDays();
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_TIMESTAMP)) {
                TimestampWritable timestampWritable = (TimestampWritable)object;
                long seconds = timestampWritable.getSeconds();
                int nanos = timestampWritable.getNanos();
                this.longs[column] = seconds * 1000L + (long)(nanos / 1000000) + this.timeZoneCorrection;
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_BYTE)) {
                ByteWritable byteWritable = (ByteWritable)object;
                this.longs[column] = byteWritable.get();
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_INT)) {
                IntWritable intWritable = (IntWritable)object;
                this.longs[column] = intWritable.get();
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_LONG)) {
                LongWritable longWritable = (LongWritable)object;
                this.longs[column] = longWritable.get();
            } else {
                throw new RuntimeException(String.format("%s is not a valid LONG type", type));
            }
        }
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        Object object = OrcUtil.getFieldValue(this.row, this.hiveColumnIndexes[column]);
        if (object == null) {
            this.nulls[column] = true;
        } else {
            this.nulls[column] = false;
            HiveType type = this.hiveTypes[column];
            if (this.hiveTypes[column].equals(HiveType.HIVE_FLOAT)) {
                FloatWritable floatWritable = (FloatWritable)object;
                this.doubles[column] = floatWritable.get();
            } else if (this.hiveTypes[column].equals(HiveType.HIVE_DOUBLE)) {
                DoubleWritable doubleWritable = (DoubleWritable)object;
                this.doubles[column] = doubleWritable.get();
            } else {
                throw new RuntimeException(String.format("%s is not a valid DOUBLE type", type));
            }
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        Preconditions.checkArgument((!this.isPartitionColumn[column] ? 1 : 0) != 0, (Object)"Column is a partition key");
        this.loaded[column] = true;
        this.nulls[column] = false;
        Object object = OrcUtil.getFieldValue(this.row, this.hiveColumnIndexes[column]);
        if (object == null) {
            this.nulls[column] = true;
            return;
        }
        HiveType type = this.hiveTypes[column];
        if (HiveUtil.isStructuralType(type)) {
            this.slices[column] = Slices.wrappedBuffer((byte[])SerDeUtils.getJsonBytes(this.sessionTimeZone, object, this.fieldInspectors[column]));
        } else if (type.equals(HiveType.HIVE_STRING)) {
            Text text = Types.checkType(object, Text.class, "materialized string value");
            this.slices[column] = Slices.copyOf((Slice)Slices.wrappedBuffer((byte[])text.getBytes()), (int)0, (int)text.getLength());
        } else if (type.equals(HiveType.HIVE_BINARY)) {
            BytesWritable bytesWritable = Types.checkType(object, BytesWritable.class, "materialized binary value");
            this.slices[column] = Slices.copyOf((Slice)Slices.wrappedBuffer((byte[])bytesWritable.getBytes()), (int)0, (int)bytesWritable.getLength());
        } else {
            throw new RuntimeException(String.format("%s is not a valid STRING type", type));
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        if (this.types[column].equals(BooleanType.BOOLEAN)) {
            this.parseBooleanColumn(column);
        } else if (this.types[column].equals(BigintType.BIGINT)) {
            this.parseLongColumn(column);
        } else if (this.types[column].equals(DoubleType.DOUBLE)) {
            this.parseDoubleColumn(column);
        } else if (this.types[column].equals(VarcharType.VARCHAR) || this.types[column].equals(VarbinaryType.VARBINARY) || HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseStringColumn(column);
        } else if (this.types[column].equals(TimestampType.TIMESTAMP)) {
            this.parseLongColumn(column);
        } else if (this.types[column].equals(DateType.DATE)) {
            this.parseLongColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + this.types[column]);
        }
    }

    private void validateType(int fieldId, Class<?> javaType) {
        if (this.types[fieldId].getJavaType() != javaType) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", javaType.getName(), this.types[fieldId].getJavaType().getName(), fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

