/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;

public final class KafkaColumnHandle
implements ConnectorColumnHandle,
Comparable<KafkaColumnHandle> {
    private final String connectorId;
    private final int ordinalPosition;
    private final String name;
    private final Type type;
    private final String mapping;
    private final String dataFormat;
    private final String formatHint;
    private final boolean keyDecoder;
    private final boolean hidden;
    private final boolean internal;

    @JsonCreator
    public KafkaColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="keyDecoder") boolean keyDecoder, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.ordinalPosition = ordinalPosition;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.mapping = mapping;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.keyDecoder = keyDecoder;
        this.hidden = hidden;
        this.internal = internal;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public boolean isKeyDecoder() {
        return this.keyDecoder;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.name, this.type, this.ordinalPosition, false, null, this.hidden);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.ordinalPosition, this.name, this.type, this.mapping, this.dataFormat, this.formatHint, this.keyDecoder, this.hidden, this.internal});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaColumnHandle other = (KafkaColumnHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)other.connectorId) && Objects.equal((Object)this.ordinalPosition, (Object)other.ordinalPosition) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.mapping, (Object)other.mapping) && Objects.equal((Object)this.dataFormat, (Object)other.dataFormat) && Objects.equal((Object)this.formatHint, (Object)other.formatHint) && Objects.equal((Object)this.keyDecoder, (Object)other.keyDecoder) && Objects.equal((Object)this.hidden, (Object)other.hidden) && Objects.equal((Object)this.internal, (Object)other.internal);
    }

    @Override
    public int compareTo(KafkaColumnHandle otherHandle) {
        return Ints.compare((int)this.getOrdinalPosition(), (int)otherHandle.getOrdinalPosition());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("ordinalPosition", this.ordinalPosition).add("name", (Object)this.name).add("type", (Object)this.type).add("mapping", (Object)this.mapping).add("dataFormat", (Object)this.dataFormat).add("formatHint", (Object)this.formatHint).add("keyDecoder", this.keyDecoder).add("hidden", this.hidden).add("internal", this.internal).toString();
    }
}

