/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import javax.inject.Inject;

public class KafkaHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    @Inject
    KafkaHandleResolver(@Named(value="connectorId") String connectorId, KafkaConnectorConfig kafkaConnectorConfig) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)kafkaConnectorConfig, (Object)"kafkaConfig is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle != null && tableHandle instanceof KafkaTableHandle && this.connectorId.equals(((KafkaTableHandle)tableHandle).getConnectorId());
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle != null && columnHandle instanceof KafkaColumnHandle && this.connectorId.equals(((KafkaColumnHandle)columnHandle).getConnectorId());
    }

    public boolean canHandle(ConnectorSplit split) {
        return split != null && split instanceof KafkaSplit && this.connectorId.equals(((KafkaSplit)split).getConnectorId());
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        return false;
    }

    public boolean canHandle(ConnectorInsertTableHandle tableHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return KafkaTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return KafkaColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return KafkaSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    public Class<? extends ConnectorInsertTableHandle> getInsertTableHandleClass() {
        throw new UnsupportedOperationException();
    }

    KafkaTableHandle convertTableHandle(ConnectorTableHandle tableHandle) {
        Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof KafkaTableHandle), (Object)"tableHandle is not an instance of KafkaTableHandle");
        KafkaTableHandle kafkaTableHandle = (KafkaTableHandle)tableHandle;
        Preconditions.checkArgument((boolean)kafkaTableHandle.getConnectorId().equals(this.connectorId), (Object)"tableHandle is not for this connector");
        return kafkaTableHandle;
    }

    KafkaColumnHandle convertColumnHandle(ConnectorColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof KafkaColumnHandle), (Object)"columnHandle is not an instance of KafkaColumnHandle");
        KafkaColumnHandle kafkaColumnHandle = (KafkaColumnHandle)columnHandle;
        Preconditions.checkArgument((boolean)kafkaColumnHandle.getConnectorId().equals(this.connectorId), (Object)"columnHandle is not for this connector");
        return kafkaColumnHandle;
    }

    KafkaSplit convertSplit(ConnectorSplit split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof KafkaSplit), (Object)"split is not an instance of KafkaSplit");
        KafkaSplit kafkaSplit = (KafkaSplit)split;
        Preconditions.checkArgument((boolean)kafkaSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        return kafkaSplit;
    }
}

