/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.csv;

import au.com.bytecode.opencsv.CSVParser;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.kafka.decoder.KafkaRowDecoder;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class CsvKafkaRowDecoder
implements KafkaRowDecoder {
    public static final String NAME = "csv";
    private final CSVParser parser = new CSVParser();

    @Inject
    CsvKafkaRowDecoder() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean decodeRow(byte[] data, Set<KafkaFieldValueProvider> fieldValueProviders, List<KafkaColumnHandle> columnHandles, Map<KafkaColumnHandle, KafkaFieldDecoder<?>> fieldDecoders) {
        String[] fields;
        try {
            String line = new String(data, StandardCharsets.UTF_8);
            fields = this.parser.parseLine(line);
        }
        catch (Exception e) {
            return true;
        }
        for (KafkaColumnHandle columnHandle : columnHandles) {
            KafkaFieldDecoder<?> decoder;
            if (columnHandle.isInternal()) continue;
            String mapping = columnHandle.getMapping();
            Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for column handle %s!", (Object[])new Object[]{columnHandle});
            int columnIndex = Integer.parseInt(mapping);
            if (columnIndex >= fields.length || (decoder = fieldDecoders.get(columnHandle)) == null) continue;
            fieldValueProviders.add(decoder.decode(fields[columnIndex], columnHandle));
        }
        return false;
    }
}

