/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.json;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.json.JsonKafkaFieldDecoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Locale;
import java.util.Set;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SecondsSinceEpochJsonKafkaFieldDecoder
extends JsonKafkaFieldDecoder {
    @VisibleForTesting
    static final String NAME = "seconds-since-epoch";
    @VisibleForTesting
    static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withLocale(Locale.ENGLISH).withZoneUTC();

    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Long.TYPE, Slice.class);
    }

    @Override
    public String getFieldDecoderName() {
        return NAME;
    }

    @Override
    public KafkaFieldValueProvider decode(JsonNode value, KafkaColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new SecondsSinceEpochJsonKafkaValueProvider(value, columnHandle);
    }

    public static class SecondsSinceEpochJsonKafkaValueProvider
    extends JsonKafkaFieldDecoder.JsonKafkaValueProvider {
        public SecondsSinceEpochJsonKafkaValueProvider(JsonNode value, KafkaColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        public boolean getBoolean() {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONVERSION_NOT_SUPPORTED, "conversion to boolean not supported");
        }

        @Override
        public double getDouble() {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONVERSION_NOT_SUPPORTED, "conversion to double not supported");
        }

        @Override
        public long getLong() {
            return this.isNull() ? 0L : this.value.asLong() * 1000L;
        }

        @Override
        public Slice getSlice() {
            return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)FORMATTER.print(this.value.asLong() * 1000L));
        }
    }
}

