/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnector;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaMetadata;
import com.facebook.presto.kafka.KafkaRecordSetProvider;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplitManager;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.decoder.KafkaDecoderModule;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import javax.inject.Inject;

public class KafkaConnectorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(KafkaConnector.class).in(Scopes.SINGLETON);
        binder.bind(KafkaHandleResolver.class).in(Scopes.SINGLETON);
        binder.bind(KafkaMetadata.class).in(Scopes.SINGLETON);
        binder.bind(KafkaSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(KafkaRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(KafkaSimpleConsumerManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(KafkaConnectorConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(KafkaTopicDescription.class);
        binder.install((Module)new KafkaDecoderModule());
        for (KafkaInternalFieldDescription internalFieldDescription : KafkaInternalFieldDescription.getInternalFields()) {
            KafkaConnectorModule.bindInternalColumn(binder, internalFieldDescription);
        }
    }

    private static void bindInternalColumn(Binder binder, KafkaInternalFieldDescription fieldDescription) {
        Multibinder fieldDescriptionBinder = Multibinder.newSetBinder((Binder)binder, KafkaInternalFieldDescription.class);
        fieldDescriptionBinder.addBinding().toInstance((Object)fieldDescription);
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private static final long serialVersionUID = 1L;
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object[])new Object[]{value});
            return type;
        }
    }
}

