/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class KafkaMetadata
extends ReadOnlyConnectorMetadata {
    private static final Logger log = Logger.get(KafkaMetadata.class);
    private final String connectorId;
    private final KafkaConnectorConfig kafkaConnectorConfig;
    private final KafkaHandleResolver handleResolver;
    private final Supplier<Map<SchemaTableName, KafkaTopicDescription>> kafkaTableDescriptionSupplier;
    private final Set<KafkaInternalFieldDescription> internalFieldDescriptions;

    @Inject
    KafkaMetadata(@Named(value="connectorId") String connectorId, KafkaConnectorConfig kafkaConnectorConfig, KafkaHandleResolver handleResolver, Supplier<Map<SchemaTableName, KafkaTopicDescription>> kafkaTableDescriptionSupplier, Set<KafkaInternalFieldDescription> internalFieldDescriptions) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.kafkaConnectorConfig = (KafkaConnectorConfig)Preconditions.checkNotNull((Object)kafkaConnectorConfig, (Object)"kafkaConfig is null");
        this.handleResolver = (KafkaHandleResolver)Preconditions.checkNotNull((Object)handleResolver, (Object)"handleResolver is null");
        log.debug("Loading kafka table definitions from %s", new Object[]{kafkaConnectorConfig.getTableDescriptionDir().getAbsolutePath()});
        this.kafkaTableDescriptionSupplier = Suppliers.memoize(kafkaTableDescriptionSupplier);
        this.internalFieldDescriptions = (Set)Preconditions.checkNotNull(internalFieldDescriptions, (Object)"internalFieldDescriptions is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            builder.add((Object)tableName.getSchemaName());
        }
        return ImmutableList.copyOf((Collection)builder.build());
    }

    public KafkaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        KafkaTopicDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return new KafkaTableHandle(this.connectorId, schemaTableName.getSchemaName(), schemaTableName.getTableName(), table.getTopicName(), KafkaMetadata.getDataFormat(table.getKey()), KafkaMetadata.getDataFormat(table.getMessage()));
    }

    private static String getDataFormat(KafkaTopicFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        KafkaTableHandle kafkaTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        return this.getTableMetadata(kafkaTableHandle.toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            if (schemaNameOrNull != null && !tableName.getSchemaName().equals(schemaNameOrNull)) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        List<KafkaTopicFieldDescription> fields;
        KafkaTopicFieldGroup message;
        List<KafkaTopicFieldDescription> fields2;
        KafkaTableHandle kafkaTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        KafkaTopicDescription kafkaTopicDescription = this.getDefinedTables().get(kafkaTableHandle.toSchemaTableName());
        if (kafkaTopicDescription == null) {
            throw new TableNotFoundException(kafkaTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        KafkaTopicFieldGroup key = kafkaTopicDescription.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields2) {
                columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, true, index++));
            }
        }
        if ((message = kafkaTopicDescription.getMessage()) != null && (fields = message.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields) {
                columnHandles.put((Object)kafkaTopicFieldDescription.getName(), (Object)kafkaTopicFieldDescription.getColumnHandle(this.connectorId, false, index++));
            }
        }
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : this.internalFieldDescriptions) {
            columnHandles.put((Object)kafkaInternalFieldDescription.getName(), (Object)kafkaInternalFieldDescription.getColumnHandle(this.connectorId, index++, this.kafkaConnectorConfig.isHideInternalColumns()));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getSchemaName() == null ? this.listTables(session, null) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        this.handleResolver.convertTableHandle(tableHandle);
        KafkaColumnHandle kafkaColumnHandle = this.handleResolver.convertColumnHandle(columnHandle);
        return kafkaColumnHandle.getColumnMetadata();
    }

    @VisibleForTesting
    Map<SchemaTableName, KafkaTopicDescription> getDefinedTables() {
        return (Map)this.kafkaTableDescriptionSupplier.get();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        List<KafkaTopicFieldDescription> fields;
        KafkaTopicFieldGroup message;
        List<KafkaTopicFieldDescription> fields2;
        KafkaTopicDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int index = 0;
        KafkaTopicFieldGroup key = table.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (KafkaTopicFieldDescription kafkaTopicFieldDescription : fields2) {
                builder.add((Object)kafkaTopicFieldDescription.getColumnMetadata(index++));
            }
        }
        if ((message = table.getMessage()) != null && (fields = message.getFields()) != null) {
            for (KafkaTopicFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata(index++));
            }
        }
        for (KafkaInternalFieldDescription kafkaInternalFieldDescription : this.internalFieldDescriptions) {
            builder.add((Object)kafkaInternalFieldDescription.getColumnMetadata(index++, this.kafkaConnectorConfig.isHideInternalColumns()));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }
}

