/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class KafkaPartition
implements ConnectorPartition {
    private final String topicName;
    private final int partitionId;
    private final HostAddress partitionLeader;
    private final List<HostAddress> partitionNodes;

    public KafkaPartition(String topicName, int partitionId, HostAddress partitionLeader, List<HostAddress> partitionNodes) {
        this.topicName = (String)Preconditions.checkNotNull((Object)topicName, (Object)"schema name is null");
        this.partitionId = partitionId;
        this.partitionLeader = (HostAddress)Preconditions.checkNotNull((Object)partitionLeader, (Object)"partitionLeader is null");
        this.partitionNodes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionNodes, (Object)"partitionNodes is null")));
    }

    public String getPartitionId() {
        return Integer.toString(this.partitionId);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getPartitionIdAsInt() {
        return this.partitionId;
    }

    public HostAddress getPartitionLeader() {
        return this.partitionLeader;
    }

    public List<HostAddress> getPartitionNodes() {
        return this.partitionNodes;
    }

    public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
        return TupleDomain.all();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topicName", (Object)this.topicName).add("partitionId", this.partitionId).add("partitionLeader", (Object)this.partitionLeader).add("partitionNodes", this.partitionNodes).toString();
    }
}

