/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaRecordSet;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.decoder.KafkaDecoderRegistry;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.kafka.decoder.KafkaRowDecoder;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class KafkaRecordSetProvider
implements ConnectorRecordSetProvider {
    private final KafkaHandleResolver handleResolver;
    private final KafkaSimpleConsumerManager consumerManager;
    private final KafkaDecoderRegistry registry;

    @Inject
    public KafkaRecordSetProvider(KafkaDecoderRegistry registry, KafkaHandleResolver handleResolver, KafkaSimpleConsumerManager consumerManager) {
        this.registry = (KafkaDecoderRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry is null");
        this.handleResolver = (KafkaHandleResolver)Preconditions.checkNotNull((Object)handleResolver, (Object)"handleResolver is null");
        this.consumerManager = (KafkaSimpleConsumerManager)Preconditions.checkNotNull((Object)consumerManager, (Object)"consumerManager is null");
    }

    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        KafkaSplit kafkaSplit = this.handleResolver.convertSplit(split);
        ImmutableList.Builder handleBuilder = ImmutableList.builder();
        ImmutableMap.Builder keyFieldDecoderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder messageFieldDecoderBuilder = ImmutableMap.builder();
        KafkaRowDecoder keyDecoder = this.registry.getRowDecoder(kafkaSplit.getKeyDataFormat());
        KafkaRowDecoder messageDecoder = this.registry.getRowDecoder(kafkaSplit.getMessageDataFormat());
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            KafkaFieldDecoder<?> fieldDecoder;
            KafkaColumnHandle columnHandle = this.handleResolver.convertColumnHandle(connectorColumnHandle);
            handleBuilder.add((Object)columnHandle);
            if (columnHandle.isInternal()) continue;
            if (columnHandle.isKeyDecoder()) {
                fieldDecoder = this.registry.getFieldDecoder(kafkaSplit.getKeyDataFormat(), columnHandle.getType().getJavaType(), columnHandle.getDataFormat());
                keyFieldDecoderBuilder.put((Object)columnHandle, fieldDecoder);
                continue;
            }
            fieldDecoder = this.registry.getFieldDecoder(kafkaSplit.getMessageDataFormat(), columnHandle.getType().getJavaType(), columnHandle.getDataFormat());
            messageFieldDecoderBuilder.put((Object)columnHandle, fieldDecoder);
        }
        ImmutableList handles = handleBuilder.build();
        ImmutableMap immutableMap = keyFieldDecoderBuilder.build();
        ImmutableMap messageFieldDecoders = messageFieldDecoderBuilder.build();
        return new KafkaRecordSet(kafkaSplit, this.consumerManager, (List<KafkaColumnHandle>)handles, keyDecoder, messageDecoder, (Map<KafkaColumnHandle, KafkaFieldDecoder<?>>)immutableMap, (Map<KafkaColumnHandle, KafkaFieldDecoder<?>>)messageFieldDecoders);
    }
}

