/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder;

import com.facebook.presto.kafka.decoder.KafkaDecoderRegistry;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.kafka.decoder.KafkaRowDecoder;
import com.facebook.presto.kafka.decoder.csv.CsvKafkaDecoderModule;
import com.facebook.presto.kafka.decoder.dummy.DummyKafkaDecoderModule;
import com.facebook.presto.kafka.decoder.json.JsonKafkaDecoderModule;
import com.facebook.presto.kafka.decoder.raw.RawKafkaDecoderModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;

public class KafkaDecoderModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(KafkaDecoderRegistry.class).in(Scopes.SINGLETON);
        binder.install((Module)new DummyKafkaDecoderModule());
        binder.install((Module)new CsvKafkaDecoderModule());
        binder.install((Module)new JsonKafkaDecoderModule());
        binder.install((Module)new RawKafkaDecoderModule());
    }

    public static void bindRowDecoder(Binder binder, Class<? extends KafkaRowDecoder> decoderClass) {
        Multibinder rowDecoderBinder = Multibinder.newSetBinder((Binder)binder, KafkaRowDecoder.class);
        rowDecoderBinder.addBinding().to(decoderClass).in(Scopes.SINGLETON);
    }

    public static void bindFieldDecoder(Binder binder, Class<? extends KafkaFieldDecoder<?>> decoderClass) {
        Multibinder fieldDecoderBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<KafkaFieldDecoder<?>>(){});
        fieldDecoderBinder.addBinding().to(decoderClass).in(Scopes.SINGLETON);
    }
}

