/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder;

import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.kafka.decoder.KafkaRowDecoder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class KafkaDecoderRegistry {
    private static final Logger log = Logger.get(KafkaDecoderRegistry.class);
    private final Map<String, KafkaRowDecoder> rowDecoders;
    private final Map<String, SetMultimap<Class<?>, KafkaFieldDecoder<?>>> fieldDecoders;

    @Inject
    KafkaDecoderRegistry(Set<KafkaRowDecoder> rowDecoders, Set<KafkaFieldDecoder<?>> fieldDecoders) {
        Preconditions.checkNotNull(rowDecoders, (Object)"rowDecoders is null");
        ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
        for (KafkaRowDecoder kafkaRowDecoder : rowDecoders) {
            rowBuilder.put((Object)kafkaRowDecoder.getName(), (Object)kafkaRowDecoder);
        }
        this.rowDecoders = rowBuilder.build();
        HashMap<String, ImmutableSetMultimap.Builder> fieldDecoderBuilders = new HashMap<String, ImmutableSetMultimap.Builder>();
        for (KafkaFieldDecoder<?> kafkaFieldDecoder : fieldDecoders) {
            ImmutableSetMultimap.Builder fieldDecoderBuilder = (ImmutableSetMultimap.Builder)fieldDecoderBuilders.get(kafkaFieldDecoder.getRowDecoderName());
            if (fieldDecoderBuilder == null) {
                fieldDecoderBuilder = ImmutableSetMultimap.builder();
                fieldDecoderBuilders.put(kafkaFieldDecoder.getRowDecoderName(), fieldDecoderBuilder);
            }
            for (Class<?> clazz : kafkaFieldDecoder.getJavaTypes()) {
                fieldDecoderBuilder.put(clazz, kafkaFieldDecoder);
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : fieldDecoderBuilders.entrySet()) {
            builder.put(entry.getKey(), (Object)((ImmutableSetMultimap.Builder)entry.getValue()).build());
        }
        this.fieldDecoders = builder.build();
        log.debug("Field decoders found: %s", new Object[]{this.fieldDecoders});
    }

    public KafkaRowDecoder getRowDecoder(String dataFormat) {
        Preconditions.checkState((boolean)this.rowDecoders.containsKey(dataFormat), (String)"no row decoder for '%s' found", (Object[])new Object[]{dataFormat});
        return this.rowDecoders.get(dataFormat);
    }

    public KafkaFieldDecoder<?> getFieldDecoder(String rowDataFormat, Class<?> fieldType, @Nullable String fieldDataFormat) {
        Preconditions.checkNotNull((Object)rowDataFormat, (Object)"rowDataFormat is null");
        Preconditions.checkNotNull(fieldType, (Object)"fieldType is null");
        Preconditions.checkState((boolean)this.fieldDecoders.containsKey(rowDataFormat), (String)"no field decoders for '%s' found", (Object[])new Object[]{rowDataFormat});
        Set decoders = this.fieldDecoders.get(rowDataFormat).get(fieldType);
        ImmutableSet fieldNames = ImmutableSet.of((Object)Objects.firstNonNull((Object)fieldDataFormat, (Object)"_default"), (Object)"_default");
        for (String fieldName : fieldNames) {
            for (KafkaFieldDecoder decoder : decoders) {
                if (!fieldName.equals(decoder.getFieldDecoderName())) continue;
                return decoder;
            }
        }
        throw new IllegalStateException(String.format("No field decoder for %s/%s found!", rowDataFormat, fieldType));
    }
}

