/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.dummy;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Set;

public class DummyKafkaFieldDecoder
implements KafkaFieldDecoder<Void> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public final String getRowDecoderName() {
        return "dummy";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public KafkaFieldValueProvider decode(Void value, KafkaColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        return new KafkaFieldValueProvider(){

            @Override
            public boolean accept(KafkaColumnHandle handle) {
                return false;
            }

            @Override
            public boolean isNull() {
                throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONVERSION_NOT_SUPPORTED, "is null check not supported");
            }
        };
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

