/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.json;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.json.JsonKafkaFieldDecoder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Locale;
import java.util.Set;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class RFC2822JsonKafkaFieldDecoder
extends JsonKafkaFieldDecoder {
    @VisibleForTesting
    static final String NAME = "rfc2822";
    @VisibleForTesting
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.ENGLISH).withZoneUTC();

    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Long.TYPE, Slice.class);
    }

    @Override
    public String getFieldDecoderName() {
        return NAME;
    }

    @Override
    public KafkaFieldValueProvider decode(JsonNode value, KafkaColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new RFC2822JsonKafkaValueProvider(value, columnHandle);
    }

    public static class RFC2822JsonKafkaValueProvider
    extends JsonKafkaFieldDecoder.JsonKafkaValueProvider {
        public RFC2822JsonKafkaValueProvider(JsonNode value, KafkaColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        public boolean getBoolean() {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONVERSION_NOT_SUPPORTED, "conversion to boolean not supported");
        }

        @Override
        public double getDouble() {
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_CONVERSION_NOT_SUPPORTED, "conversion to double not supported");
        }

        @Override
        public long getLong() {
            if (this.isNull()) {
                return 0L;
            }
            if (this.value.canConvertToLong()) {
                return this.value.asLong();
            }
            String textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            return FORMATTER.parseMillis(textValue);
        }
    }
}

