/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kafka.javaapi.consumer.SimpleConsumer;

public class KafkaSimpleConsumerManager {
    private static final Logger log = Logger.get(KafkaSimpleConsumerManager.class);
    private final LoadingCache<HostAddress, SimpleConsumer> consumerCache;
    private final String connectorId;
    private final KafkaConnectorConfig kafkaConnectorConfig;
    private final NodeManager nodeManager;

    @Inject
    KafkaSimpleConsumerManager(@Named(value="connectorId") String connectorId, KafkaConnectorConfig kafkaConnectorConfig, NodeManager nodeManager) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.kafkaConnectorConfig = (KafkaConnectorConfig)Preconditions.checkNotNull((Object)kafkaConnectorConfig, (Object)"kafkaConfig is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.consumerCache = CacheBuilder.newBuilder().build((CacheLoader)new SimpleConsumerCacheLoader());
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry entry : this.consumerCache.asMap().entrySet()) {
            try {
                ((SimpleConsumer)entry.getValue()).close();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "While closing consumer %s:", new Object[]{entry.getKey()});
            }
        }
    }

    public SimpleConsumer getConsumer(HostAddress host) {
        Preconditions.checkNotNull((Object)host, (Object)"host is null");
        try {
            return (SimpleConsumer)this.consumerCache.get((Object)host);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private class SimpleConsumerCacheLoader
    extends CacheLoader<HostAddress, SimpleConsumer> {
        private SimpleConsumerCacheLoader() {
        }

        public SimpleConsumer load(HostAddress host) throws Exception {
            log.info("Creating new Consumer for %s", new Object[]{host});
            return new SimpleConsumer(host.getHostText(), host.getPort(), Ints.checkedCast((long)KafkaSimpleConsumerManager.this.kafkaConnectorConfig.getKafkaConnectTimeout().toMillis()), Ints.checkedCast((long)KafkaSimpleConsumerManager.this.kafkaConnectorConfig.getKafkaBufferSize().toBytes()), String.format("presto-kafka-%s-%s", KafkaSimpleConsumerManager.this.connectorId, KafkaSimpleConsumerManager.this.nodeManager.getCurrentNode().getNodeIdentifier()));
        }
    }
}

