/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class KafkaSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;
    private final int partitionId;
    private final long start;
    private final long end;
    private final List<HostAddress> nodes;

    @JsonCreator
    public KafkaSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="nodes") List<HostAddress> nodes) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connector id is null");
        this.topicName = (String)Preconditions.checkNotNull((Object)topicName, (Object)"topicName is null");
        this.keyDataFormat = (String)Preconditions.checkNotNull((Object)keyDataFormat, (Object)"dataFormat is null");
        this.messageDataFormat = (String)Preconditions.checkNotNull((Object)messageDataFormat, (Object)"messageDataFormat is null");
        this.partitionId = partitionId;
        this.start = start;
        this.end = end;
        this.nodes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(nodes, (Object)"addresses is null")));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getEnd() {
        return this.end;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty
    public List<HostAddress> getNodes() {
        return this.nodes;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.nodes;
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).add("partitionId", this.partitionId).add("start", this.start).add("end", this.end).add("nodes", this.nodes).toString();
    }
}

