/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaPartition;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(KafkaSplitManager.class);
    private final String connectorId;
    private final KafkaConnectorConfig kafkaConnectorConfig;
    private final KafkaHandleResolver handleResolver;
    private final KafkaSimpleConsumerManager consumerManager;

    @Inject
    public KafkaSplitManager(@Named(value="connectorId") String connectorId, KafkaConnectorConfig kafkaConnectorConfig, KafkaHandleResolver handleResolver, KafkaSimpleConsumerManager consumerManager) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.kafkaConnectorConfig = (KafkaConnectorConfig)Preconditions.checkNotNull((Object)kafkaConnectorConfig, (Object)"kafkaConfig is null");
        this.handleResolver = (KafkaHandleResolver)Preconditions.checkNotNull((Object)handleResolver, (Object)"handleResolver is null");
        this.consumerManager = (KafkaSimpleConsumerManager)Preconditions.checkNotNull((Object)consumerManager, (Object)"consumerManager is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        KafkaTableHandle kafkaTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        ArrayList<HostAddress> nodes = new ArrayList<HostAddress>(this.kafkaConnectorConfig.getNodes());
        Collections.shuffle(nodes);
        SimpleConsumer simpleConsumer = this.consumerManager.getConsumer((HostAddress)nodes.get(0));
        try {
            TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest((List)ImmutableList.of((Object)kafkaTableHandle.getTopicName()));
            TopicMetadataResponse topicMetadataResponse = simpleConsumer.send(topicMetadataRequest);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (TopicMetadata metadata : topicMetadataResponse.topicsMetadata()) {
                for (PartitionMetadata part : metadata.partitionsMetadata()) {
                    log.debug("Adding Partition %s/%s", new Object[]{metadata.topic(), part.partitionId()});
                    Broker leader = part.leader();
                    if (leader == null) {
                        log.warn("No leader for partition %s/%s found!", new Object[]{metadata.topic(), part.partitionId()});
                        continue;
                    }
                    builder.add((Object)new KafkaPartition(metadata.topic(), part.partitionId(), HostAddress.fromParts((String)leader.host(), (int)leader.port()), (List<HostAddress>)ImmutableList.copyOf((Collection)Lists.transform((List)part.isr(), KafkaSplitManager::brokerToHostAddress))));
                }
            }
            return new ConnectorPartitionResult((List)builder.build(), tupleDomain);
        }
        catch (Exception e) {
            throw new TableNotFoundException(kafkaTableHandle.toSchemaTableName(), (Throwable)e);
        }
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> partitions) {
        KafkaTableHandle kafkaTableHandle = this.handleResolver.convertTableHandle(tableHandle);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ConnectorPartition cp : partitions) {
            Preconditions.checkState((boolean)(cp instanceof KafkaPartition), (String)"Found an unknown partition type: %s", (Object[])new Object[]{cp.getClass().getSimpleName()});
            KafkaPartition partition = (KafkaPartition)cp;
            SimpleConsumer leaderConsumer = this.consumerManager.getConsumer(partition.getPartitionLeader());
            long[] offsets = KafkaSplitManager.findAllOffsets(leaderConsumer, partition);
            for (int i = offsets.length - 1; i > 0; --i) {
                KafkaSplit split = new KafkaSplit(this.connectorId, partition.getTopicName(), kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), partition.getPartitionIdAsInt(), offsets[i], offsets[i - 1], partition.getPartitionNodes());
                builder.add((Object)split);
            }
        }
        return new FixedSplitSource(this.connectorId, (Iterable)builder.build());
    }

    private static long[] findAllOffsets(SimpleConsumer consumer, KafkaPartition partition) {
        PartitionOffsetRequestInfo partitionOffsetRequestInfo;
        TopicAndPartition topicAndPartition = new TopicAndPartition(partition.getTopicName(), partition.getPartitionIdAsInt());
        OffsetRequest offsetRequest = new OffsetRequest((Map)ImmutableMap.of((Object)topicAndPartition, (Object)(partitionOffsetRequestInfo = new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), Integer.MAX_VALUE))), kafka.api.OffsetRequest.CurrentVersion(), consumer.clientId());
        OffsetResponse offsetResponse = consumer.getOffsetsBefore(offsetRequest);
        if (offsetResponse.hasError()) {
            short errorCode = offsetResponse.errorCode(partition.getTopicName(), partition.getPartitionIdAsInt());
            log.warn("Offset response has error: %d", new Object[]{errorCode});
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, "could not fetch data from Kafka, error code is '" + errorCode + "'");
        }
        return offsetResponse.offsets(partition.getTopicName(), partition.getPartitionIdAsInt());
    }

    private static HostAddress brokerToHostAddress(Broker broker) {
        return HostAddress.fromParts((String)broker.host(), (int)broker.port());
    }
}

