/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.kafka.KafkaTopicFieldDescription;
import com.facebook.presto.kafka.KafkaTopicFieldGroup;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class KafkaTableDescriptionSupplier
implements Supplier<Map<SchemaTableName, KafkaTopicDescription>> {
    private static final Logger log = Logger.get(KafkaTableDescriptionSupplier.class);
    private final KafkaConnectorConfig kafkaConnectorConfig;
    private final JsonCodec<KafkaTopicDescription> topicDescriptionCodec;

    @Inject
    KafkaTableDescriptionSupplier(KafkaConnectorConfig kafkaConnectorConfig, JsonCodec<KafkaTopicDescription> topicDescriptionCodec) {
        this.kafkaConnectorConfig = (KafkaConnectorConfig)Preconditions.checkNotNull((Object)kafkaConnectorConfig, (Object)"kafkaConnectorConfig is null");
        this.topicDescriptionCodec = (JsonCodec)Preconditions.checkNotNull(topicDescriptionCodec, (Object)"topicDescriptionCodec is null");
    }

    public Map<SchemaTableName, KafkaTopicDescription> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (File file : KafkaTableDescriptionSupplier.listFiles(this.kafkaConnectorConfig.getTableDescriptionDir())) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                KafkaTopicDescription table = (KafkaTopicDescription)this.topicDescriptionCodec.fromJson(Files.toByteArray((File)file));
                String schemaName = (String)Objects.firstNonNull((Object)table.getSchemaName(), (Object)this.kafkaConnectorConfig.getDefaultSchema());
                log.debug("Kafka table %s.%s: %s", new Object[]{schemaName, table.getTableName(), table});
                builder.put((Object)new SchemaTableName(schemaName, table.getTableName()), (Object)table);
            }
            ImmutableMap tableDefinitions = builder.build();
            log.debug("Loaded Table definitions: %s", new Object[]{tableDefinitions.keySet()});
            builder = ImmutableMap.builder();
            for (String definedTable : this.kafkaConnectorConfig.getTableNames()) {
                SchemaTableName tableName;
                try {
                    tableName = SchemaTableName.valueOf((String)definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.kafkaConnectorConfig.getDefaultSchema(), definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) {
                    KafkaTopicDescription kafkaTable = (KafkaTopicDescription)tableDefinitions.get(tableName);
                    log.debug("Found Table definition for %s: %s", new Object[]{tableName, kafkaTable});
                    builder.put((Object)tableName, (Object)kafkaTable);
                    continue;
                }
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new KafkaTopicDescription(tableName.getTableName(), tableName.getSchemaName(), definedTable, new KafkaTopicFieldGroup("dummy", (List<KafkaTopicFieldDescription>)ImmutableList.of()), new KafkaTopicFieldGroup("dummy", (List<KafkaTopicFieldDescription>)ImmutableList.of())));
            }
            return builder.build();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Error: ");
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }
}

