/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class KafkaTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;

    @JsonCreator
    public KafkaTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schemaName is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        this.topicName = (String)Preconditions.checkNotNull((Object)topicName, (Object)"topicName is null");
        this.keyDataFormat = (String)Preconditions.checkNotNull((Object)keyDataFormat, (Object)"keyDataFormat is null");
        this.messageDataFormat = (String)Preconditions.checkNotNull((Object)messageDataFormat, (Object)"messageDataFormat is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.schemaName, this.tableName, this.topicName, this.keyDataFormat, this.messageDataFormat});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaTableHandle other = (KafkaTableHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)other.connectorId) && Objects.equal((Object)this.schemaName, (Object)other.schemaName) && Objects.equal((Object)this.tableName, (Object)other.tableName) && Objects.equal((Object)this.topicName, (Object)other.topicName) && Objects.equal((Object)this.keyDataFormat, (Object)other.keyDataFormat) && Objects.equal((Object)this.messageDataFormat, (Object)other.messageDataFormat);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).toString();
    }
}

