/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.json;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Set;

public class JsonKafkaFieldDecoder
implements KafkaFieldDecoder<JsonNode> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public final String getRowDecoderName() {
        return "json";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public KafkaFieldValueProvider decode(JsonNode value, KafkaColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new JsonKafkaValueProvider(value, columnHandle);
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }

    public static class JsonKafkaValueProvider
    extends KafkaFieldValueProvider {
        protected final JsonNode value;
        protected final KafkaColumnHandle columnHandle;

        public JsonKafkaValueProvider(JsonNode value, KafkaColumnHandle columnHandle) {
            this.value = value;
            this.columnHandle = columnHandle;
        }

        @Override
        public final boolean accept(KafkaColumnHandle columnHandle) {
            return this.columnHandle.equals(columnHandle);
        }

        @Override
        public final boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        @Override
        public boolean getBoolean() {
            return this.value.asBoolean();
        }

        @Override
        public long getLong() {
            return this.value.asLong();
        }

        @Override
        public double getDouble() {
            return this.value.asDouble();
        }

        @Override
        public Slice getSlice() {
            String textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)textValue);
        }
    }
}

