/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnector;
import com.facebook.presto.kafka.KafkaConnectorModule;
import com.facebook.presto.kafka.KafkaTableDescriptionSupplier;
import com.facebook.presto.kafka.KafkaTopicDescription;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final TypeManager typeManager;
    private final NodeManager nodeManager;
    private final Optional<Supplier<Map<SchemaTableName, KafkaTopicDescription>>> tableDescriptionSupplier;
    private final Map<String, String> optionalConfig;

    KafkaConnectorFactory(TypeManager typeManager, NodeManager nodeManager, Optional<Supplier<Map<SchemaTableName, KafkaTopicDescription>>> tableDescriptionSupplier, Map<String, String> optionalConfig) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.optionalConfig = (Map)Preconditions.checkNotNull(optionalConfig, (Object)"optionalConfig is null");
        this.tableDescriptionSupplier = (Optional)Preconditions.checkNotNull(tableDescriptionSupplier, (Object)"tableDescriptionSupplier is null");
    }

    public String getName() {
        return "kafka";
    }

    public Connector create(final String connectorId, Map<String, String> config) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull(config, (Object)"config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new KafkaConnectorModule(), new Module(){

                public void configure(Binder binder) {
                    binder.bindConstant().annotatedWith((Annotation)Names.named((String)"connectorId")).to(connectorId);
                    binder.bind(TypeManager.class).toInstance((Object)KafkaConnectorFactory.this.typeManager);
                    binder.bind(NodeManager.class).toInstance((Object)KafkaConnectorFactory.this.nodeManager);
                    if (KafkaConnectorFactory.this.tableDescriptionSupplier.isPresent()) {
                        binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, KafkaTopicDescription>>>(){}).toInstance(KafkaConnectorFactory.this.tableDescriptionSupplier.get());
                    } else {
                        binder.bind((TypeLiteral)new TypeLiteral<Supplier<Map<SchemaTableName, KafkaTopicDescription>>>(){}).to(KafkaTableDescriptionSupplier.class).in(Scopes.SINGLETON);
                    }
                }
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(KafkaConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

