/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.csv;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Set;

public class CsvKafkaFieldDecoder
implements KafkaFieldDecoder<String> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public String getRowDecoderName() {
        return "csv";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public KafkaFieldValueProvider decode(final String value, final KafkaColumnHandle columnHandle) {
        Preconditions.checkNotNull((Object)columnHandle, (Object)"columnHandle is null");
        return new KafkaFieldValueProvider(){

            @Override
            public boolean accept(KafkaColumnHandle handle) {
                return columnHandle.equals(handle);
            }

            @Override
            public boolean isNull() {
                return value == null || value.isEmpty();
            }

            @Override
            public boolean getBoolean() {
                return this.isNull() ? false : Boolean.parseBoolean(value.trim());
            }

            @Override
            public long getLong() {
                return this.isNull() ? 0L : Long.parseLong(value.trim());
            }

            @Override
            public double getDouble() {
                return this.isNull() ? 0.0 : Double.parseDouble(value.trim());
            }

            @Override
            public Slice getSlice() {
                return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)value);
            }
        };
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

