/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.decoder.json;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaFieldValueProvider;
import com.facebook.presto.kafka.decoder.KafkaFieldDecoder;
import com.facebook.presto.kafka.decoder.KafkaRowDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class JsonKafkaRowDecoder
implements KafkaRowDecoder {
    public static final String NAME = "json";
    private final ObjectMapper objectMapper;

    @Inject
    JsonKafkaRowDecoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean decodeRow(byte[] data, Set<KafkaFieldValueProvider> fieldValueProviders, List<KafkaColumnHandle> columnHandles, Map<KafkaColumnHandle, KafkaFieldDecoder<?>> fieldDecoders) {
        JsonNode tree;
        try {
            tree = this.objectMapper.readTree(data);
        }
        catch (Exception e) {
            return true;
        }
        for (KafkaColumnHandle columnHandle : columnHandles) {
            KafkaFieldDecoder<?> decoder;
            if (columnHandle.isInternal() || (decoder = fieldDecoders.get(columnHandle)) == null) continue;
            JsonNode node = JsonKafkaRowDecoder.locateNode(tree, columnHandle);
            fieldValueProviders.add(decoder.decode(node, columnHandle));
        }
        return false;
    }

    private static JsonNode locateNode(JsonNode tree, KafkaColumnHandle columnHandle) {
        String mapping = columnHandle.getMapping();
        Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for %s", (Object[])new Object[]{columnHandle.getName()});
        JsonNode currentNode = tree;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)mapping)) {
            if (!currentNode.has(pathElement)) {
                return MissingNode.getInstance();
            }
            currentNode = currentNode.path(pathElement);
        }
        return currentNode;
    }
}

