/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestHiddenColumns {
    private LocalQueryRunner runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);

    public TestHiddenColumns() {
        this.runner.createCatalog(SessionTestUtils.TEST_SESSION.getCatalog(), (ConnectorFactory)new TpchConnectorFactory((NodeManager)this.runner.getNodeManager(), 1), (Map)ImmutableMap.of());
    }

    @AfterClass
    public void destroy() {
        if (this.runner != null) {
            this.runner.close();
        }
    }

    @Test
    public void testDescribeTable() throws Exception {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BooleanType.BOOLEAN, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"regionkey", "bigint", true, false, ""}).row(new Object[]{"name", "varchar", true, false, ""}).row(new Object[]{"comment", "varchar", true, false, ""}).build();
        Assert.assertEquals((Iterable)this.runner.execute("DESC REGION"), (Iterable)expected);
    }

    @Test
    public void testSimpleSelect() throws Exception {
        Assert.assertEquals((Iterable)this.runner.execute("SELECT * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, * from REGION"), (Iterable)this.runner.execute("SELECT row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number, * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, x.row_number from REGION x"), (Iterable)this.runner.execute("SELECT row_number, row_number from REGION"));
    }
}

