/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.FixedWidthBlockBuilder;
import io.airlift.slice.Slice;
import org.testng.annotations.Test;

public class TestFixedWidthBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        for (int fixedSize = 0; fixedSize < 20; ++fixedSize) {
            Object[] expectedValues = TestFixedWidthBlock.createExpectedValues(17, fixedSize);
            TestFixedWidthBlock.assertFixedWithValues((Slice[])expectedValues, fixedSize);
            TestFixedWidthBlock.assertFixedWithValues((Slice[])TestFixedWidthBlock.alternatingNullValues(expectedValues), fixedSize);
        }
    }

    private static void assertFixedWithValues(Slice[] expectedValues, int fixedSize) {
        FixedWidthBlockBuilder blockBuilder = new FixedWidthBlockBuilder(fixedSize, expectedValues.length);
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        }
        TestFixedWidthBlock.assertBlock((Block)blockBuilder, expectedValues);
        TestFixedWidthBlock.assertBlock(blockBuilder.build(), expectedValues);
    }

    private static Slice[] createExpectedValues(int positionCount, int fixedSize) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestFixedWidthBlock.createExpectedValue(fixedSize);
        }
        return expectedValues;
    }
}

