/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazySliceArrayBlock;
import io.airlift.slice.Slice;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLazySliceArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Object[] expectedValues = TestLazySliceArrayBlock.createExpectedValues(100);
        TestLazySliceArrayBlock.assertVariableWithValues((Slice[])expectedValues);
        TestLazySliceArrayBlock.assertVariableWithValues((Slice[])TestLazySliceArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testRelease() {
        TestLazySliceArrayBlockLoader loader = new TestLazySliceArrayBlockLoader(new Slice[10]);
        LazySliceArrayBlock block = new LazySliceArrayBlock(10, (LazyBlockLoader)loader);
        block.assureLoaded();
        Assert.assertTrue((boolean)loader.loaded);
    }

    private static void assertVariableWithValues(Slice[] expectedValues) {
        LazySliceArrayBlock block = new LazySliceArrayBlock(expectedValues.length, (LazyBlockLoader)new TestLazySliceArrayBlockLoader(expectedValues));
        TestLazySliceArrayBlock.assertBlock((Block)block, expectedValues);
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestLazySliceArrayBlock.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static class TestLazySliceArrayBlockLoader
    implements LazyBlockLoader<LazySliceArrayBlock> {
        private final Slice[] expectedValues;
        private boolean loaded;

        public TestLazySliceArrayBlockLoader(Slice[] expectedValues) {
            this.expectedValues = expectedValues;
        }

        public void load(LazySliceArrayBlock block) {
            if (this.expectedValues == null) {
                Assert.fail((String)"load should not be called");
            }
            block.setValues(this.expectedValues);
            this.loaded = true;
        }
    }
}

