/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.PagesSerde;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.TestingBlockEncodingManager;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesSerde {
    @Test
    public void testRoundTrip() {
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        Page expectedPage = new Page(new Block[]{expectedBlock, expectedBlock, expectedBlock});
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerde.writePages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage, expectedPage, expectedPage});
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        Iterator pageIterator = PagesSerde.readPages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceInput)sliceOutput.slice().getInput());
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        Assert.assertFalse((boolean)pageIterator.hasNext());
    }

    @Test
    public void testBigintSerializedSize() {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        Assert.assertEquals((int)pageSize, (int)35);
        BigintType.BIGINT.writeLong(builder, 123L);
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)9);
        BigintType.BIGINT.writeLong(builder, 456L);
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)8);
    }

    @Test
    public void testVarcharSerializedSize() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page);
        Assert.assertEquals((int)pageSize, (int)34);
        VarcharType.VARCHAR.writeString(builder, "alice");
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)10);
        VarcharType.VARCHAR.writeString(builder, "bob");
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)7);
    }

    private static int serializedSize(List<? extends Type> types, Page expectedPage) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerde.writePages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage});
        Slice slice = sliceOutput.slice();
        Iterator pageIterator = PagesSerde.readPages((BlockEncodingSerde)TestingBlockEncodingManager.createTestingBlockEncodingManager(), (SliceInput)slice.getInput());
        if (pageIterator.hasNext()) {
            PageAssertions.assertPageEquals(types, (Page)pageIterator.next(), expectedPage);
        } else {
            Assert.assertEquals((int)expectedPage.getPositionCount(), (int)0);
        }
        Assert.assertFalse((boolean)pageIterator.hasNext());
        return slice.length();
    }
}

