/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import io.airlift.slice.Slice;
import org.testng.annotations.Test;

public class TestVariableWidthBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Object[] expectedValues = TestVariableWidthBlock.createExpectedValues(100);
        TestVariableWidthBlock.assertVariableWithValues((Slice[])expectedValues);
        TestVariableWidthBlock.assertVariableWithValues((Slice[])TestVariableWidthBlock.alternatingNullValues(expectedValues));
    }

    private static void assertVariableWithValues(Slice[] expectedValues) {
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus());
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeBytes(expectedValue, 0, expectedValue.length()).closeEntry();
        }
        TestVariableWidthBlock.assertBlock((Block)blockBuilder, expectedValues);
        TestVariableWidthBlock.assertBlock(blockBuilder.build(), expectedValues);
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestVariableWidthBlock.createExpectedValue(position);
        }
        return expectedValues;
    }
}

