/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SimpleDomain;
import com.facebook.presto.execution.SimpleMarker;
import com.facebook.presto.execution.SimpleRange;
import com.facebook.presto.spi.SerializableNativeValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleDomain {
    private static final JsonCodec<SimpleDomain> codec = JsonCodec.jsonCodec(SimpleDomain.class);

    @Test
    public void testRoundTrip() {
        SimpleMarker low = new SimpleMarker(true, new SerializableNativeValue(Long.class, (Comparable)new Long(10L)));
        SimpleMarker high = new SimpleMarker(false, new SerializableNativeValue(Long.class, (Comparable)new Long(100L)));
        ImmutableList ranges = ImmutableList.of((Object)new SimpleRange(Optional.fromNullable((Object)low), Optional.fromNullable((Object)high)));
        SimpleDomain expected = new SimpleDomain(true, Optional.fromNullable((Object)ranges));
        String json = codec.toJson((Object)expected);
        SimpleDomain actual = (SimpleDomain)codec.fromJson(json);
        Assert.assertEquals((Object)actual, (Object)expected);
    }
}

