/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.ParametricFunctionUtils;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.CustomFunctions;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFunctionRegistry {
    @Test
    public void testIdentityCast() {
        FunctionRegistry registry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        FunctionInfo exactOperator = registry.getCoercion((Type)HyperLogLogType.HYPER_LOG_LOG, (Type)HyperLogLogType.HYPER_LOG_LOG);
        Assert.assertEquals((String)exactOperator.getSignature().getName(), (String)FunctionRegistry.mangleOperatorName((String)OperatorType.CAST.name()));
        Assert.assertEquals((Collection)Lists.transform((List)exactOperator.getArgumentTypes(), (Function)Functions.toStringFunction()), (Collection)ImmutableList.of((Object)"HyperLogLog"));
        Assert.assertEquals((String)exactOperator.getReturnType().getBase(), (String)"HyperLogLog");
    }

    @Test
    public void testExactMatchBeforeCoercion() {
        TypeRegistry typeManager = new TypeRegistry();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)typeManager, true);
        boolean foundOperator = false;
        for (ParametricFunction function : registry.listOperators()) {
            OperatorType operatorType = FunctionRegistry.unmangleOperator((String)function.getSignature().getName());
            if (operatorType == OperatorType.CAST || function.isUnbound()) continue;
            FunctionInfo exactOperator = registry.resolveOperator(operatorType, TypeUtils.resolveTypes((List)function.getSignature().getArgumentTypes(), (TypeManager)typeManager));
            Assert.assertEquals((Object)exactOperator.getSignature(), (Object)function.getSignature());
            foundOperator = true;
        }
        Assert.assertTrue((boolean)foundOperator);
    }

    @Test
    public void testMagicLiteralFunction() {
        Signature signature = FunctionRegistry.getMagicLiteralFunctionSignature((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        Assert.assertEquals((String)signature.getName(), (String)"$literal$timestamp with time zone");
        Assert.assertEquals((Collection)signature.getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
        FunctionRegistry registry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        FunctionInfo function = registry.resolveFunction(QualifiedName.of((String)signature.getName(), (String[])new String[0]), signature.getArgumentTypes(), false);
        Assert.assertEquals((Collection)function.getArgumentTypes(), (Collection)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"bigint")));
        Assert.assertEquals((String)signature.getReturnType().getBase(), (String)"timestamp with time zone");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="\\QFunction already registered: custom_add(bigint,bigint):bigint\\E")
    public void testDuplicateFunctions() {
        List functions = new FunctionListBuilder((TypeManager)new TypeRegistry()).scalar(CustomFunctions.class).getFunctions();
        functions = FluentIterable.from((Iterable)functions).filter((Predicate)new Predicate<ParametricFunction>(){

            public boolean apply(ParametricFunction input) {
                return input.getSignature().getName().equals("custom_add");
            }
        }).toList();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        registry.addFunctions(functions);
        registry.addFunctions(functions);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="'sum' is both an aggregation and a scalar function")
    public void testConflictingScalarAggregation() throws Exception {
        List functions = new FunctionListBuilder((TypeManager)new TypeRegistry()).scalar(ScalarSum.class).getFunctions();
        FunctionRegistry registry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        registry.addFunctions(functions);
    }

    @Test
    public void testListingHiddenFunctions() throws Exception {
        FunctionRegistry registry = new FunctionRegistry((TypeManager)new TypeRegistry(), true);
        List functions = registry.list();
        List names = Lists.transform((List)functions, (Function)ParametricFunctionUtils.nameGetter());
        Assert.assertTrue((boolean)names.contains("length"), (String)("Expected function names " + names + " to contain 'length'"));
        Assert.assertTrue((boolean)names.contains("stddev"), (String)("Expected function names " + names + " to contain 'stddev'"));
        Assert.assertTrue((boolean)names.contains("rank"), (String)("Expected function names " + names + " to contain 'rank'"));
        Assert.assertFalse((boolean)names.contains("at_time_zone"), (String)("Expected function names " + names + " not to contain 'at_time_zone'"));
    }

    public static final class ScalarSum {
        private ScalarSum() {
        }

        @ScalarFunction
        @SqlType(value="bigint")
        public static long sum(@SqlType(value="bigint") long a, @SqlType(value="bigint") long b) {
            return a + b;
        }
    }
}

