/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignature {
    @Test
    public void testRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TypeRegistry())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider, true).jsonCodec(Signature.class);
        Signature expected = new Signature("function", "bigint", (List)ImmutableList.of((Object)"boolean", (Object)"double", (Object)"varchar"));
        String json = codec.toJson((Object)expected);
        Signature actual = (Signature)codec.fromJson(json);
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((Object)actual.getReturnType(), (Object)expected.getReturnType());
        Assert.assertEquals((Collection)actual.getArgumentTypes(), (Collection)expected.getArgumentTypes());
    }

    @Test
    public void testBasic() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("foo", (List)ImmutableList.of((Object)Signature.typeParameter((String)"T")), "T", (List)ImmutableList.of((Object)"T"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>"))), true, (TypeManager)typeManager));
    }

    @Test
    public void testNonParametric() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("foo", (List)ImmutableList.of(), "boolean", (List)ImmutableList.of((Object)"bigint"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>"))), true, (TypeManager)typeManager));
    }

    @Test
    public void testArray() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("get", (List)ImmutableList.of((Object)Signature.typeParameter((String)"T")), "T", (List)ImmutableList.of((Object)"array<T>"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>"))), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        signature = new Signature("contains", (List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T")), "T", (List)ImmutableList.of((Object)"array<T>", (Object)"T"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>")), (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>")), (Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<HyperLogLog>")), (Object)HyperLogLogType.HYPER_LOG_LOG), true, (TypeManager)typeManager));
        signature = new Signature("foo", (List)ImmutableList.of((Object)Signature.typeParameter((String)"T")), "T", (List)ImmutableList.of((Object)"array<T>", (Object)"array<T>"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>")), (Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>"))), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<bigint>")), (Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"array<varchar>"))), true, (TypeManager)typeManager));
    }

    @Test
    public void testMap() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("get", (List)ImmutableList.of((Object)Signature.typeParameter((String)"K"), (Object)Signature.typeParameter((String)"V")), "V", (List)ImmutableList.of((Object)"map<K,V>", (Object)"K"), false, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"map<bigint,varchar>")), (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)typeManager.getType(TypeSignature.parseTypeSignature((String)"map<bigint,varchar>")), (Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
    }

    @Test
    public void testVarArgs() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("foo", (List)ImmutableList.of((Object)Signature.typeParameter((String)"T")), "boolean", (List)ImmutableList.of((Object)"T"), true, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
    }

    @Test
    public void testCoercion() throws Exception {
        TypeRegistry typeManager = new TypeRegistry();
        Signature signature = new Signature("foo", (List)ImmutableList.of((Object)Signature.typeParameter((String)"T")), "boolean", (List)ImmutableList.of((Object)"T", (Object)"double"), true, true);
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNotNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), true, (TypeManager)typeManager));
        Assert.assertNull((Object)signature.bindTypeParameters((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), true, (TypeManager)typeManager));
    }
}

