/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;

public class RowPageBuilder {
    private final List<Type> types;
    private final List<BlockBuilder> builders;
    private long rowCount;

    public static RowPageBuilder rowPageBuilder(Type ... types) {
        return RowPageBuilder.rowPageBuilder((Iterable<Type>)ImmutableList.copyOf((Object[])types));
    }

    public static RowPageBuilder rowPageBuilder(Iterable<Type> types) {
        return new RowPageBuilder(types);
    }

    RowPageBuilder(Iterable<Type> types) {
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        ImmutableList.Builder builders = ImmutableList.builder();
        for (Type type : types) {
            builders.add((Object)type.createBlockBuilder(new BlockBuilderStatus()));
        }
        this.builders = builders.build();
        Preconditions.checkArgument((!this.builders.isEmpty() ? 1 : 0) != 0, (Object)"At least one value info is required");
    }

    public boolean isEmpty() {
        return this.rowCount == 0L;
    }

    public RowPageBuilder row(Object ... values) {
        Preconditions.checkArgument((values.length == this.builders.size() ? 1 : 0) != 0, (String)"Expected %s values, but got %s", (Object[])new Object[]{this.builders.size(), values.length});
        for (int channel = 0; channel < values.length; ++channel) {
            this.append(channel, values[channel]);
        }
        ++this.rowCount;
        return this;
    }

    public Page build() {
        Block[] blocks = new Block[this.builders.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.builders.get(i).build();
        }
        return new Page(blocks);
    }

    private void append(int channel, Object value) {
        BlockBuilder builder = this.builders.get(channel);
        Type type = this.types.get(channel);
        Class javaType = type.getJavaType();
        if (value == null) {
            builder.appendNull();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(builder, ((Boolean)value).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(builder, ((Number)value).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(builder, ((Double)value).doubleValue());
        } else if (javaType == Slice.class) {
            Slice slice = Slices.utf8Slice((String)((String)value));
            type.writeSlice(builder, slice, 0, slice.length());
        } else {
            throw new IllegalArgumentException("bad value: " + value.getClass().getName());
        }
    }
}

