/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.RowPageBuilder;
import com.facebook.presto.operator.SequencePageBuilder;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class RowPagesBuilder {
    private final ImmutableList.Builder<Page> pages = ImmutableList.builder();
    private final List<Type> types;
    private RowPageBuilder builder;

    public static RowPagesBuilder rowPagesBuilder(Type ... types) {
        return RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.copyOf((Object[])types));
    }

    public static RowPagesBuilder rowPagesBuilder(Iterable<Type> types) {
        return new RowPagesBuilder(types);
    }

    RowPagesBuilder(Iterable<Type> types) {
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.builder = RowPageBuilder.rowPageBuilder(types);
    }

    public RowPagesBuilder addSequencePage(int length, int ... initialValues) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be at least 1");
        Preconditions.checkNotNull((Object)initialValues, (Object)"initialValues is null");
        Preconditions.checkArgument((initialValues.length == this.types.size() ? 1 : 0) != 0, (String)"Expected %s initialValues, but got %s", (Object[])new Object[]{this.types.size(), initialValues.length});
        this.pageBreak();
        Page page = SequencePageBuilder.createSequencePage(this.types, length, initialValues);
        this.pages.add((Object)page);
        return this;
    }

    public RowPagesBuilder addBlocksPage(Block ... blocks) {
        this.pages.add((Object)new Page(blocks));
        return this;
    }

    public RowPagesBuilder row(Object ... values) {
        this.builder.row(values);
        return this;
    }

    public RowPagesBuilder pageBreak() {
        if (!this.builder.isEmpty()) {
            this.pages.add((Object)this.builder.build());
            this.builder = RowPageBuilder.rowPageBuilder(this.types);
        }
        return this;
    }

    public List<Page> build() {
        this.pageBreak();
        return this.pages.build();
    }
}

