/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFilterAndProjectOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void test() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(100, 0, 0).build();
        FilterFunction filter = new FilterFunction(){

            public boolean filter(int position, Block ... blocks) {
                long value = BigintType.BIGINT.getLong(blocks[1], position);
                return 10L <= value && value < 20L;
            }

            public boolean filter(RecordCursor cursor) {
                long value = cursor.getLong(0);
                return 10L <= value && value < 20L;
            }
        };
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, (PageProcessor)new GenericPageProcessor(filter, (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)VarcharType.VARCHAR, (int)0), (Object)new Add5Projection(1))), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"10", 15}).row(new Object[]{"11", 16}).row(new Object[]{"12", 17}).row(new Object[]{"13", 18}).row(new Object[]{"14", 19}).row(new Object[]{"15", 20}).row(new Object[]{"16", 21}).row(new Object[]{"17", 22}).row(new Object[]{"18", 23}).row(new Object[]{"19", 24}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    private static class Add5Projection
    implements ProjectionFunction {
        private final int channelIndex;

        public Add5Projection(int channelIndex) {
            this.channelIndex = channelIndex;
        }

        public Type getType() {
            return BigintType.BIGINT;
        }

        public void project(int position, Block[] blocks, BlockBuilder output) {
            if (blocks[this.channelIndex].isNull(position)) {
                output.appendNull();
            } else {
                BigintType.BIGINT.writeLong(output, BigintType.BIGINT.getLong(blocks[this.channelIndex], position) + 5L);
            }
        }

        public void project(RecordCursor cursor, BlockBuilder output) {
            if (cursor.isNull(this.channelIndex)) {
                output.appendNull();
            } else {
                BigintType.BIGINT.writeLong(output, cursor.getLong(this.channelIndex) + 5L);
            }
        }
    }
}

