/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupByHash {
    private static final int MAX_GROUP_ID = 500;

    @Test
    public void test() throws Exception {
        GroupByHash groupByHash = new GroupByHash((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, 100);
        for (int tries = 0; tries < 2; ++tries) {
            for (int value = 0; value < 500; ++value) {
                Page page = new Page(new Block[]{BlockAssertions.createLongsBlock(value)});
                for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                    GroupByIdBlock groupIds = groupByHash.getGroupIds(page);
                    Assert.assertEquals((long)groupIds.getGroupCount(), (long)(tries == 0 ? (long)(value + 1) : 500L));
                    Assert.assertEquals((int)groupIds.getPositionCount(), (int)1);
                    long groupId = groupIds.getGroupId(0);
                    Assert.assertEquals((long)groupId, (long)value);
                }
            }
        }
    }
}

