/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.operator.aggregation.VarBinaryMaxAggregation;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashAggregationOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testHashAggregation() throws Exception {
        MetadataManager metadata = new MetadataManager();
        InternalAggregationFunction countVarcharColumn = metadata.resolveFunction(QualifiedName.of((String)"count", (String[])new String[0]), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar")), false).getAggregationFunction();
        InternalAggregationFunction countBooleanColumn = metadata.resolveFunction(QualifiedName.of((String)"count", (String[])new String[0]), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"boolean")), false).getAggregationFunction();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN}).addSequencePage(10, 100, 0, 100, 0, 500).addSequencePage(10, 100, 0, 200, 0, 500).addSequencePage(10, 100, 0, 300, 0, 500).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{1}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0), (Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.absent(), Optional.absent(), 1.0), (Object)AverageAggregations.LONG_AVERAGE.bind((List)ImmutableList.of((Object)3), Optional.absent(), Optional.absent(), 1.0), (Object)VarBinaryMaxAggregation.VAR_BINARY_MAX.bind((List)ImmutableList.of((Object)2), Optional.absent(), Optional.absent(), 1.0), (Object)countVarcharColumn.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0), (Object)countBooleanColumn.bind((List)ImmutableList.of((Object)4), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"0", 3, 0, 0.0, "300", 3, 3}).row(new Object[]{"1", 3, 3, 1.0, "301", 3, 3}).row(new Object[]{"2", 3, 6, 2.0, "302", 3, 3}).row(new Object[]{"3", 3, 9, 3.0, "303", 3, 3}).row(new Object[]{"4", 3, 12, 4.0, "304", 3, 3}).row(new Object[]{"5", 3, 15, 5.0, "305", 3, 3}).row(new Object[]{"6", 3, 18, 6.0, "306", 3, 3}).row(new Object[]{"7", 3, 21, 7.0, "307", 3, 3}).row(new Object[]{"8", 3, 24, 8.0, "308", 3, 3}).row(new Object[]{"9", 3, 27, 9.0, "309", 3, 3}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder(operator, input, expected);
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size of 10B")
    public void testMemoryLimit() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(10, 100, 0, 100, 0).addSequencePage(10, 100, 0, 200, 0).addSequencePage(10, 100, 0, 300, 0).build();
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(10.0, DataSize.Unit.BYTE)).addPipelineContext(true, true).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{1}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0), (Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)3), Optional.absent(), Optional.absent(), 1.0), (Object)AverageAggregations.LONG_AVERAGE.bind((List)ImmutableList.of((Object)3), Optional.absent(), Optional.absent(), 1.0), (Object)VarBinaryMaxAggregation.VAR_BINARY_MAX.bind((List)ImmutableList.of((Object)2), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        Operator operator = operatorFactory.createOperator(driverContext);
        OperatorAssertion.toPages(operator, input);
    }

    @Test
    public void testHashBuilderResize() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        VarcharType.VARCHAR.writeSlice(builder, Slices.allocate((int)200000));
        builder.build();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR}).addSequencePage(10, 100).addBlocksPage(builder.build()).addSequencePage(10, 100).build();
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(10.0, DataSize.Unit.MEGABYTE)).addPipelineContext(true, true).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        Operator operator = operatorFactory.createOperator(driverContext);
        OperatorAssertion.toPages(operator, input);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size of 3MB")
    public void testHashBuilderResizeLimit() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(new BlockBuilderStatus());
        VarcharType.VARCHAR.writeSlice(builder, Slices.allocate((int)5000000));
        builder.build();
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR}).addSequencePage(10, 100).addBlocksPage(builder.build()).addSequencePage(10, 100).build();
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(3.0, DataSize.Unit.MEGABYTE)).addPipelineContext(true, true).addDriverContext();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        Operator operator = operatorFactory.createOperator(driverContext);
        OperatorAssertion.toPages(operator, input);
    }

    @Test
    public void testMultiSliceAggregationOutput() {
        int fixedWidthSize = 24;
        int multiSlicePositionCount = (int)(1572864.0 / (double)fixedWidthSize);
        multiSlicePositionCount = Math.min(12288, multiSlicePositionCount);
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).addSequencePage(multiSlicePositionCount, 0, 0).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{1}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)CountAggregation.COUNT.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0), (Object)AverageAggregations.LONG_AVERAGE.bind((List)ImmutableList.of((Object)1), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        Operator operator = operatorFactory.createOperator(this.driverContext);
        Assert.assertEquals((int)OperatorAssertion.toPages(operator, input).size(), (int)2);
    }

    @Test
    public void testMultiplePartialFlushes() throws Exception {
        Page output;
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(500, 0).addSequencePage(500, 500).addSequencePage(500, 1000).addSequencePage(500, 1500).build();
        HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), AggregationNode.Step.PARTIAL, (List)ImmutableList.of((Object)LongSumAggregation.LONG_SUM.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0)), 100000, new DataSize(16.0, DataSize.Unit.MEGABYTE));
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(1.0, DataSize.Unit.KILOBYTE)).addPipelineContext(true, true).addDriverContext();
        Operator operator = operatorFactory.createOperator(driverContext);
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, BigintType.BIGINT}).addSequencePage(2000, 0, 0).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).pages(expectedPages).build();
        Iterator<Page> inputIterator = input.iterator();
        while (operator.needsInput() && inputIterator.hasNext()) {
            operator.addInput(inputIterator.next());
        }
        ArrayList<Page> outputPages = new ArrayList<Page>();
        while ((output = operator.getOutput()) != null) {
            outputPages.add(output);
        }
        Assert.assertTrue((!outputPages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)operator.needsInput());
        outputPages.addAll(OperatorAssertion.toPages(operator, inputIterator));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(operator.getOperatorContext().getSession(), operator.getTypes(), outputPages);
        Assert.assertEquals((Collection)actual.getTypes(), (Collection)expected.getTypes());
        Assertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }
}

