/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHashSemiJoinOperator {
    private ExecutorService executor;
    private TaskContext taskContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.taskContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION);
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSemiJoin() throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row(10).row(30).row(30).row(35).row(36).row(37).row(50).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        List<Page> probeInput = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes).addSequencePage(10, 30, 0).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), (List)probeTypes, 0);
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{30, 0, true}).row(new Object[]{31, 1, false}).row(new Object[]{32, 2, false}).row(new Object[]{33, 3, false}).row(new Object[]{34, 4, false}).row(new Object[]{35, 5, true}).row(new Object[]{36, 6, true}).row(new Object[]{37, 7, true}).row(new Object[]{38, 8, false}).row(new Object[]{39, 9, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected);
    }

    @Test
    public void testBuildSideNulls() throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row(0).row(1).row(2).row(2).row(3).row(new Object[]{null}).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List<Page> probeInput = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes).addSequencePage(4, 1).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), (List)probeTypes, 0);
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{1, true}).row(new Object[]{2, true}).row(new Object[]{3, true}).row(new Object[]{4, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected);
    }

    @Test
    public void testProbeSideNulls() throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row(0).row(1).row(3).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List<Page> probeInput = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes).row(0).row(new Object[]{null}).row(1).row(2).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), (List)probeTypes, 0);
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0, true}).row(new Object[]{null, null}).row(new Object[]{1, true}).row(new Object[]{2, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected);
    }

    @Test
    public void testProbeAndBuildNulls() throws Exception {
        DriverContext driverContext = this.taskContext.addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).row(0).row(1).row(new Object[]{null}).row(3).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        List<Page> probeInput = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)probeTypes).row(0).row(new Object[]{null}).row(1).row(2).build();
        HashSemiJoinOperator.HashSemiJoinOperatorFactory joinOperatorFactory = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(2, setBuilderOperatorFactory.getSetProvider(), (List)probeTypes, 0);
        Operator joinOperator = joinOperatorFactory.createOperator(driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0, true}).row(new Object[]{null, null}).row(new Object[]{1, true}).row(new Object[]{2, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperator, probeInput, expected);
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size.*")
    public void testMemoryLimit() throws Exception {
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(100.0, DataSize.Unit.BYTE)).addPipelineContext(true, true).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, (List)buildTypes, RowPagesBuilder.rowPagesBuilder((Iterable<Type>)buildTypes).addSequencePage(10000, 20).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, buildOperator.getTypes(), 0, 10);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = new Driver(driverContext, (Operator)buildOperator, new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.process();
        }
    }
}

