/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNOperator {
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSingleFieldKey() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.1).row(2, 0.2).pageBreak().row(-1, -0.1).row(4, 0.4).pageBreak().row(5, 0.5).row(4, 0.41).row(6, 0.6).pageBreak().build();
        TopNOperator.TopNOperatorFactory factory = new TopNOperator.TopNOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST), false);
        Operator operator = factory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{6, 0.6}).row(new Object[]{5, 0.5}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testMultiFieldKey() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row("a", 1).row("b", 2).pageBreak().row("f", 3).row("a", 4).pageBreak().row("d", 5).row("d", 7).row("e", 6).build();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 3, (List)ImmutableList.of((Object)0, (Object)1), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_LAST), false);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"f", 3}).row(new Object[]{"e", 6}).row(new Object[]{"d", 7}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testReverseOrder() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.1).row(2, 0.2).pageBreak().row(-1, -0.1).row(4, 0.4).pageBreak().row(5, 0.5).row(4, 0.41).row(6, 0.6).pageBreak().build();
        TopNOperator.TopNOperatorFactory operatorFactory = new TopNOperator.TopNOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), false);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{-1, -0.1}).row(new Object[]{1, 0.1}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

