/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.RowPagesBuilder;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.LagFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.LeadFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedResult;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestWindowOperator {
    private static final List<WindowFunctionDefinition> ROW_NUMBER = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("row_number", (Type)BigintType.BIGINT, (List)ImmutableList.of(), RowNumberFunction.class), (Integer[])new Integer[0]));
    private static final List<WindowFunctionDefinition> FIRST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("first_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR), FirstValueFunction.VarcharFirstValueFunction.class), (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> LAST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("last_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR), LastValueFunction.VarcharLastValueFunction.class), (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> NTH_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("nth_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), NthValueFunction.VarcharNthValueFunction.class), (Integer[])new Integer[]{1, 3}));
    private static final List<WindowFunctionDefinition> LAG = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("lag", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LagFunction.VarcharLagFunction.class), (Integer[])new Integer[]{1, 3, 4}));
    private static final List<WindowFunctionDefinition> LEAD = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("lead", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LeadFunction.VarcharLeadFunction.class), (Integer[])new Integer[]{1, 3, 4}));
    private ExecutorService executor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test"));
        this.driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION).addPipelineContext(true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testRowNumber() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(2, 0.3).row(4, 0.2).row(6, 0.1).pageBreak().row(-1, -0.1).row(5, 0.4).build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 10);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{-0.1, -1, 1}).row(new Object[]{0.3, 2, 2}).row(new Object[]{0.2, 4, 3}).row(new Object[]{0.4, 5, 4}).row(new Object[]{0.1, 6, 5}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testRowNumberPartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN}).row("b", -1, -0.1, true).row("a", 2, 0.3, false).row("a", 4, 0.2, true).pageBreak().row("b", 5, 0.4, false).row("a", 6, 0.1, true).build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{1}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 10);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN, BigintType.BIGINT}).row(new Object[]{"a", 2, 0.3, false, 1}).row(new Object[]{"a", 4, 0.2, true, 2}).row(new Object[]{"a", 6, 0.1, true, 3}).row(new Object[]{"b", -1, -0.1, true, 1}).row(new Object[]{"b", 5, 0.4, false, 2}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testRowNumberArbitrary() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1).row(3).row(5).row(7).pageBreak().row(2).row(4).row(6).row(8).build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[0]), (List)ImmutableList.copyOf((Object[])new SortOrder[0]), 10);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1, 1}).row(new Object[]{3, 2}).row(new Object[]{5, 3}).row(new Object[]{7, 4}).row(new Object[]{2, 5}).row(new Object[]{4, 6}).row(new Object[]{6, 7}).row(new Object[]{8, 8}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Task exceeded max memory size of 10B")
    public void testMemoryLimit() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1, 0.1).row(2, 0.2).pageBreak().row(-1, -0.1).row(4, 0.4).build();
        DriverContext driverContext = new TaskContext(new TaskId("query", "stage", "task"), (Executor)this.executor, SessionTestUtils.TEST_SESSION, new DataSize(10.0, DataSize.Unit.BYTE)).addPipelineContext(true, true).addDriverContext();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 10);
        Operator operator = operatorFactory.createOperator(driverContext);
        OperatorAssertion.toPages(operator, input);
    }

    @Test
    public void testFirstValuePartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1, true, "").row("a", "A2", 1, false, "").row("a", "B1", 2, true, "").pageBreak().row("b", "C1", 2, false, "").row("a", "C2", 3, true, "").row("c", "A3", 1, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), FIRST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 100);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1, false, "A2"}).row(new Object[]{"a", "B1", 2, true, "A2"}).row(new Object[]{"a", "C2", 3, true, "A2"}).row(new Object[]{"b", "A1", 1, true, "A1"}).row(new Object[]{"b", "C1", 2, false, "A1"}).row(new Object[]{"c", "A3", 1, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testLastValuePartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1, true, "").row("a", "A2", 1, false, "").row("a", "B1", 2, true, "").pageBreak().row("b", "C1", 2, false, "").row("a", "C2", 3, true, "").row("c", "A3", 1, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), LAST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 100);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1, false, "C2"}).row(new Object[]{"a", "B1", 2, true, "C2"}).row(new Object[]{"a", "C2", 3, true, "C2"}).row(new Object[]{"b", "A1", 1, true, "C1"}).row(new Object[]{"b", "C1", 2, false, "C1"}).row(new Object[]{"c", "A3", 1, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testNthValuePartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1, 2, true, "").row("a", "A2", 1, 3, false, "").row("a", "B1", 2, 2, true, "").pageBreak().row("b", "C1", 2, 3, false, "").row("a", "C2", 3, 1, true, "").row("c", "A3", 1, null, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 4}), NTH_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 100);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1, false, "C2"}).row(new Object[]{"a", "B1", 2, true, "B1"}).row(new Object[]{"a", "C2", 3, true, "A2"}).row(new Object[]{"b", "A1", 1, true, "C1"}).row(new Object[]{"b", "C1", 2, false, null}).row(new Object[]{"c", "A3", 1, true, null}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testLagPartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1, 1, "D", true, "").row("a", "A2", 1, 2, "D", false, "").row("a", "B1", 2, 2, "D", true, "").pageBreak().row("b", "C1", 2, 1, "D", false, "").row("a", "C2", 3, 2, "D", true, "").row("c", "A3", 1, 1, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LAG, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 100);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1, false, "D"}).row(new Object[]{"a", "B1", 2, true, "D"}).row(new Object[]{"a", "C2", 3, true, "A2"}).row(new Object[]{"b", "A1", 1, true, "D"}).row(new Object[]{"b", "C1", 2, false, "A1"}).row(new Object[]{"c", "A3", 1, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }

    @Test
    public void testLeadPartition() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1, 1, "D", true, "").row("a", "A2", 1, 2, "D", false, "").row("a", "B1", 2, 2, "D", true, "").pageBreak().row("b", "C1", 2, 1, "D", false, "").row("a", "C2", 3, 2, "D", true, "").row("c", "A3", 1, 1, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(0, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LEAD, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}), 100);
        Operator operator = operatorFactory.createOperator(this.driverContext);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1, false, "C2"}).row(new Object[]{"a", "B1", 2, true, "D"}).row(new Object[]{"a", "C2", 3, true, "D"}).row(new Object[]{"b", "A1", 1, true, "C1"}).row(new Object[]{"b", "C1", 2, false, "D"}).row(new Object[]{"c", "A3", 1, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals(operator, input, expected);
    }
}

