/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.ApproximateCountDistinctAggregations;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.testing.Assertions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestApproximateCountDistinct {
    public abstract InternalAggregationFunction getAggregationFunction();

    public abstract Type getValueType();

    public abstract Object randomValue();

    @Test
    public void testNoPositions() throws Exception {
        this.assertCount((List<Object>)ImmutableList.of(), 0L);
    }

    @Test
    public void testSinglePosition() throws Exception {
        this.assertCount((List<Object>)ImmutableList.of((Object)this.randomValue()), 1L);
    }

    @Test
    public void testAllPositionsNull() throws Exception {
        this.assertCount(Collections.nCopies(100, null), 0L);
    }

    @Test
    public void testMixedNullsAndNonNulls() throws Exception {
        List<Object> baseline = this.createRandomSample(10000, 15000);
        ArrayList<Object> mixed = new ArrayList<Object>(baseline);
        mixed.addAll(Collections.nCopies(baseline.size(), null));
        Collections.shuffle(mixed);
        this.assertCount(mixed, this.estimateGroupByCount(baseline));
    }

    @Test
    public void testMultiplePositions() throws Exception {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < 500; ++i) {
            int uniques = ThreadLocalRandom.current().nextInt(20000) + 1;
            List<Object> values = this.createRandomSample(uniques, (int)((double)uniques * 1.5));
            long actual = this.estimateGroupByCount(values);
            double error = (double)(actual - (long)uniques) * 1.0 / (double)uniques;
            stats.addValue(error);
        }
        Assertions.assertLessThan((Comparable)Double.valueOf(stats.getMean()), (Comparable)Double.valueOf(0.01));
        Assertions.assertLessThan((Comparable)Double.valueOf(Math.abs(stats.getStandardDeviation() - ApproximateCountDistinctAggregations.getStandardError())), (Comparable)Double.valueOf(0.01));
    }

    @Test
    public void testMultiplePositionsPartial() throws Exception {
        for (int i = 0; i < 100; ++i) {
            int uniques = ThreadLocalRandom.current().nextInt(20000) + 1;
            List<Object> values = this.createRandomSample(uniques, (int)((double)uniques * 1.5));
            Assert.assertEquals((long)this.estimateCountPartial(values), (long)this.estimateGroupByCount(values));
        }
    }

    private void assertCount(List<Object> values, long expectedCount) {
        if (!values.isEmpty()) {
            Assert.assertEquals((long)this.estimateGroupByCount(values), (long)expectedCount);
        }
        Assert.assertEquals((long)this.estimateCount(values), (long)expectedCount);
        Assert.assertEquals((long)this.estimateCountPartial(values), (long)expectedCount);
    }

    private long estimateGroupByCount(List<Object> values) {
        Object result = AggregationTestUtils.groupedAggregation(this.getAggregationFunction(), 1.0, this.createPage(values));
        return (Long)result;
    }

    private long estimateCount(List<Object> values) {
        Object result = AggregationTestUtils.aggregation(this.getAggregationFunction(), 1.0, this.createPage(values));
        return (Long)result;
    }

    private long estimateCountPartial(List<Object> values) {
        Object result = AggregationTestUtils.partialAggregation(this.getAggregationFunction(), 1.0, this.createPage(values));
        return (Long)result;
    }

    private Page createPage(List<Object> values) {
        Page page = values.isEmpty() ? new Page(0, new Block[0]) : new Page(values.size(), new Block[]{this.createBlock(values)});
        return page;
    }

    private Block createBlock(List<Object> values) {
        Type type = this.getValueType();
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        for (Object value : values) {
            Class javaType = type.getJavaType();
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(blockBuilder, ((Long)value).longValue());
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(blockBuilder, ((Double)value).doubleValue());
                continue;
            }
            if (javaType == Slice.class) {
                Slice slice = (Slice)value;
                type.writeSlice(blockBuilder, slice, 0, slice.length());
                continue;
            }
            throw new UnsupportedOperationException("not yet implemented: " + javaType);
        }
        return blockBuilder.build();
    }

    private List<Object> createRandomSample(int uniques, int total) {
        Preconditions.checkArgument((uniques <= total ? 1 : 0) != 0, (String)"uniques (%s) must be <= total (%s)", (Object[])new Object[]{uniques, total});
        ArrayList<Object> result = new ArrayList<Object>(total);
        result.addAll(this.makeRandomSet(uniques));
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (result.size() < total) {
            int index = ((Random)random).nextInt(result.size());
            result.add(result.get(index));
        }
        return result;
    }

    private Set<Object> makeRandomSet(int count) {
        HashSet<Object> result = new HashSet<Object>();
        while (result.size() < count) {
            result.add(this.randomValue());
        }
        return result;
    }
}

