/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.testing.RunLengthEncodedBlock;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;

public final class AggregationTestUtils {
    private AggregationTestUtils() {
    }

    public static void assertAggregation(InternalAggregationFunction function, double confidence, Object expectedValue, int positions, Block ... blocks) {
        if (positions == 0) {
            AggregationTestUtils.assertAggregation(function, confidence, expectedValue, new Page[0]);
        } else {
            AggregationTestUtils.assertAggregation(function, confidence, expectedValue, new Page(positions, blocks));
        }
    }

    public static void assertApproximateAggregation(InternalAggregationFunction function, int sampleWeightChannel, double confidence, Double expectedValue, Page ... pages) {
        Assert.assertTrue((boolean)AggregationTestUtils.approximateAggregationWithinErrorBound(function, sampleWeightChannel, confidence, expectedValue, pages));
        Assert.assertTrue((boolean)AggregationTestUtils.partialApproximateAggregationWithinErrorBound(function, sampleWeightChannel, confidence, expectedValue, pages));
        Assert.assertTrue((boolean)AggregationTestUtils.groupedApproximateAggregationWithinErrorBound(function, sampleWeightChannel, confidence, expectedValue, pages));
    }

    public static boolean approximateAggregationWithinErrorBound(InternalAggregationFunction function, int sampleWeightChannel, double confidence, Double expectedValue, Page ... pages) {
        Accumulator accumulator = function.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.of((Object)sampleWeightChannel), confidence).createAccumulator();
        for (Page page : pages) {
            accumulator.addInput(page);
        }
        Block result = accumulator.evaluateFinal();
        if (expectedValue == null) {
            return BlockAssertions.toValues(function.getFinalType(), result).get(0) == null;
        }
        return AggregationTestUtils.withinErrorBound(BlockAssertions.toValues(function.getFinalType(), result).get(0).toString(), expectedValue);
    }

    public static boolean partialApproximateAggregationWithinErrorBound(InternalAggregationFunction function, int sampleWeightChannel, double confidence, Double expectedValue, Page ... pages) {
        AccumulatorFactory factory = function.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.of((Object)sampleWeightChannel), confidence);
        Accumulator partialAccumulator = factory.createAccumulator();
        for (Page page : pages) {
            if (page.getPositionCount() <= 0) continue;
            partialAccumulator.addInput(page);
        }
        Block partialBlock = partialAccumulator.evaluateIntermediate();
        Accumulator finalAggregation = factory.createIntermediateAccumulator();
        finalAggregation.addIntermediate(partialBlock);
        Block finalBlock = finalAggregation.evaluateFinal();
        if (expectedValue == null) {
            return BlockAssertions.toValues(function.getFinalType(), finalBlock).get(0) == null;
        }
        return AggregationTestUtils.withinErrorBound(BlockAssertions.toValues(function.getFinalType(), finalBlock).get(0).toString(), expectedValue);
    }

    public static boolean groupedApproximateAggregationWithinErrorBound(InternalAggregationFunction function, int sampleWeightChannel, double confidence, Double expectedValue, Page ... pages) {
        GroupedAccumulator groupedAggregation = function.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.of((Object)sampleWeightChannel), confidence).createGroupedAccumulator();
        for (Page page : pages) {
            groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
        }
        Object groupValue = AggregationTestUtils.getGroupValue(groupedAggregation, 0);
        if (expectedValue == null) {
            return groupValue == null;
        }
        return AggregationTestUtils.withinErrorBound(groupValue.toString(), expectedValue);
    }

    private static boolean withinErrorBound(String approximateValue, double expected) {
        List parts = Splitter.on((char)' ').splitToList((CharSequence)approximateValue);
        double actual = Double.parseDouble((String)parts.get(0));
        double error = Double.parseDouble((String)parts.get(2));
        return Math.abs(expected - actual) <= error && !Double.isInfinite(error);
    }

    public static void assertAggregation(InternalAggregationFunction function, double confidence, Object expectedValue, Page ... pages) {
        Assert.assertEquals((Object)AggregationTestUtils.aggregation(function, confidence, pages), (Object)expectedValue);
        Assert.assertEquals((Object)AggregationTestUtils.partialAggregation(function, confidence, pages), (Object)expectedValue);
        if (pages.length > 0) {
            Assert.assertEquals((Object)AggregationTestUtils.groupedAggregation(function, confidence, pages), (Object)expectedValue);
            Assert.assertEquals((Object)AggregationTestUtils.groupedPartialAggregation(function, confidence, pages), (Object)expectedValue);
            Assert.assertEquals((Object)AggregationTestUtils.distinctAggregation(function, confidence, pages), (Object)expectedValue);
        }
    }

    public static Object distinctAggregation(InternalAggregationFunction function, double confidence, Page ... pages) {
        Optional maskChannel = Optional.of((Object)pages[0].getChannelCount());
        Object aggregation = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), (Optional<Integer>)maskChannel, confidence, AggregationTestUtils.maskPages(true, pages));
        Page[] dupedPages = new Page[pages.length * 2];
        System.arraycopy(AggregationTestUtils.maskPages(true, pages), 0, dupedPages, 0, pages.length);
        System.arraycopy(AggregationTestUtils.maskPages(false, pages), 0, dupedPages, pages.length, pages.length);
        Object aggregationWithDupes = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), (Optional<Integer>)maskChannel, confidence, dupedPages);
        Assert.assertEquals((Object)aggregationWithDupes, (Object)aggregation, (String)"Inconsistent results with mask");
        return aggregation;
    }

    private static Page[] maskPages(boolean maskValue, Page ... pages) {
        Page[] maskedPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            Page page = pages[i];
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
            for (int j = 0; j < page.getPositionCount(); ++j) {
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, maskValue);
            }
            Block[] sourceBlocks = page.getBlocks();
            Block[] outputBlocks = new Block[sourceBlocks.length + 1];
            System.arraycopy(sourceBlocks, 0, outputBlocks, 0, sourceBlocks.length);
            outputBlocks[sourceBlocks.length] = blockBuilder.build();
            maskedPages[i] = new Page(outputBlocks);
        }
        return maskedPages;
    }

    public static Object aggregation(InternalAggregationFunction function, double confidence, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.aggregation(function, AggregationTestUtils.createArgs(function), (Optional<Integer>)Optional.absent(), confidence, pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.aggregation(function, AggregationTestUtils.reverseArgs(function), (Optional<Integer>)Optional.absent(), confidence, AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.aggregation(function, AggregationTestUtils.offsetArgs(function, 3), (Optional<Integer>)Optional.absent(), confidence, AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    private static Object aggregation(InternalAggregationFunction function, int[] args, Optional<Integer> maskChannel, double confidence, Page ... pages) {
        Accumulator aggregation = function.bind(Ints.asList((int[])args), maskChannel, Optional.absent(), confidence).createAccumulator();
        for (Page page : pages) {
            if (page.getPositionCount() <= 0) continue;
            aggregation.addInput(page);
        }
        Block block = aggregation.evaluateFinal();
        return BlockAssertions.getOnlyValue(aggregation.getFinalType(), block);
    }

    public static Object partialAggregation(InternalAggregationFunction function, double confidence, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.partialAggregation(function, confidence, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.partialAggregation(function, confidence, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.partialAggregation(function, confidence, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    public static Object partialAggregation(InternalAggregationFunction function, double confidence, int[] args, Page ... pages) {
        AccumulatorFactory factory = function.bind(Ints.asList((int[])args), Optional.absent(), Optional.absent(), confidence);
        Accumulator partialAggregation = factory.createAccumulator();
        for (Page page : pages) {
            if (page.getPositionCount() <= 0) continue;
            partialAggregation.addInput(page);
        }
        Block partialBlock = partialAggregation.evaluateIntermediate();
        Accumulator finalAggregation = factory.createIntermediateAccumulator();
        Block emptyBlock = factory.createAccumulator().evaluateIntermediate();
        finalAggregation.addIntermediate(emptyBlock);
        finalAggregation.addIntermediate(partialBlock);
        Block finalBlock = finalAggregation.evaluateFinal();
        return BlockAssertions.getOnlyValue(finalAggregation.getFinalType(), finalBlock);
    }

    public static Object groupedAggregation(InternalAggregationFunction function, double confidence, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.groupedAggregation(function, confidence, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.groupedAggregation(function, confidence, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.groupedAggregation(function, confidence, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    public static Object groupedAggregation(InternalAggregationFunction function, double confidence, int[] args, Page ... pages) {
        GroupedAccumulator groupedAggregation = function.bind(Ints.asList((int[])args), Optional.absent(), Optional.absent(), confidence).createGroupedAccumulator();
        for (Page page : pages) {
            groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
        }
        Object groupValue = AggregationTestUtils.getGroupValue(groupedAggregation, 0);
        for (Page page : pages) {
            groupedAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(4000, page.getPositionCount()), page);
        }
        Object largeGroupValue = AggregationTestUtils.getGroupValue(groupedAggregation, 4000);
        Assert.assertEquals((Object)largeGroupValue, (Object)groupValue, (String)"Inconsistent results with large group id");
        return groupValue;
    }

    public static Object groupedPartialAggregation(InternalAggregationFunction function, double confidence, Page ... pages) {
        Object aggregationWithOffset;
        Object aggregation = AggregationTestUtils.groupedPartialAggregation(function, confidence, AggregationTestUtils.createArgs(function), pages);
        if (function.getParameterTypes().size() > 1) {
            aggregationWithOffset = AggregationTestUtils.groupedPartialAggregation(function, confidence, AggregationTestUtils.reverseArgs(function), AggregationTestUtils.reverseColumns(pages));
            Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with reversed channels");
        }
        aggregationWithOffset = AggregationTestUtils.groupedPartialAggregation(function, confidence, AggregationTestUtils.offsetArgs(function, 3), AggregationTestUtils.offsetColumns(pages, 3));
        Assert.assertEquals((Object)aggregationWithOffset, (Object)aggregation, (String)"Inconsistent results with channel offset");
        return aggregation;
    }

    public static Object groupedPartialAggregation(InternalAggregationFunction function, double confidence, int[] args, Page ... pages) {
        AccumulatorFactory factory = function.bind(Ints.asList((int[])args), Optional.absent(), Optional.absent(), confidence);
        GroupedAccumulator partialAggregation = factory.createGroupedAccumulator();
        for (Page page : pages) {
            partialAggregation.addInput(AggregationTestUtils.createGroupByIdBlock(0, page.getPositionCount()), page);
        }
        BlockBuilder partialOut = partialAggregation.getIntermediateType().createBlockBuilder(new BlockBuilderStatus());
        partialAggregation.evaluateIntermediate(0, partialOut);
        Block partialBlock = partialOut.build();
        GroupedAccumulator finalAggregation = factory.createGroupedIntermediateAccumulator();
        GroupedAccumulator emptyAggregation = factory.createGroupedAccumulator();
        BlockBuilder emptyOut = emptyAggregation.getIntermediateType().createBlockBuilder(new BlockBuilderStatus());
        emptyAggregation.evaluateIntermediate(0, emptyOut);
        Block emptyBlock = emptyOut.build();
        finalAggregation.addIntermediate(AggregationTestUtils.createGroupByIdBlock(0, emptyBlock.getPositionCount()), emptyBlock);
        finalAggregation.addIntermediate(AggregationTestUtils.createGroupByIdBlock(0, partialBlock.getPositionCount()), partialBlock);
        return AggregationTestUtils.getGroupValue(finalAggregation, 0);
    }

    public static GroupByIdBlock createGroupByIdBlock(int groupId, int positions) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int i = 0; i < positions; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        return new GroupByIdBlock((long)groupId, blockBuilder.build());
    }

    private static int[] createArgs(InternalAggregationFunction function) {
        int[] args = new int[function.getParameterTypes().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = i;
        }
        return args;
    }

    private static int[] reverseArgs(InternalAggregationFunction function) {
        int[] args = AggregationTestUtils.createArgs(function);
        Collections.reverse(Ints.asList((int[])args));
        return args;
    }

    private static int[] offsetArgs(InternalAggregationFunction function, int offset) {
        int[] args = AggregationTestUtils.createArgs(function);
        int i = 0;
        while (i < args.length) {
            int n = i++;
            args[n] = args[n] + offset;
        }
        return args;
    }

    private static Page[] reverseColumns(Page[] pages) {
        Page[] newPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            Page page = pages[i];
            if (page.getPositionCount() == 0) {
                newPages[i] = page;
                continue;
            }
            Block[] newBlocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount());
            Collections.reverse(Arrays.asList(newBlocks));
            newPages[i] = new Page(page.getPositionCount(), newBlocks);
        }
        return newPages;
    }

    private static Page[] offsetColumns(Page[] pages, int offset) {
        Page[] newPages = new Page[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            int channel;
            Page page = pages[i];
            if (page.getPositionCount() == 0) {
                newPages[i] = page;
                continue;
            }
            Block[] newBlocks = new Block[page.getChannelCount() + offset];
            for (channel = 0; channel < offset; ++channel) {
                newBlocks[channel] = AggregationTestUtils.createNullRLEBlock(page.getPositionCount());
            }
            for (channel = 0; channel < page.getBlocks().length; ++channel) {
                newBlocks[channel + offset] = page.getBlocks()[channel];
            }
            newPages[i] = new Page(page.getPositionCount(), newBlocks);
        }
        return newPages;
    }

    private static RunLengthEncodedBlock createNullRLEBlock(int positionCount) {
        Block value = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus()).appendNull().build();
        return new RunLengthEncodedBlock(value, positionCount);
    }

    private static Object getGroupValue(GroupedAccumulator groupedAggregation, int groupId) {
        BlockBuilder out = groupedAggregation.getFinalType().createBlockBuilder(new BlockBuilderStatus());
        groupedAggregation.evaluateFinal(groupId, out);
        return BlockAssertions.getOnlyValue(groupedAggregation.getFinalType(), out.build());
    }
}

