/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.ApproximateDoublePercentileAggregations;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.testing.RunLengthEncodedBlock;
import com.google.common.base.Preconditions;
import org.testng.annotations.Test;

public class TestApproximatePercentileAggregation {
    private static final Block EMPTY_DOUBLE_BLOCK = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus()).build();
    private static final Block EMPTY_LONG_BLOCK = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus()).build();

    @Test
    public void testLongPartialStep() throws Exception {
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, null, TestApproximatePercentileAggregation.createPage(new Long[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{null}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)1L, TestApproximatePercentileAggregation.createPage(new Long[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)2L, TestApproximatePercentileAggregation.createPage(new Long[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{1L, 2L, 3L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)2L, TestApproximatePercentileAggregation.createPage(new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{2L, 3L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)3L, TestApproximatePercentileAggregation.createPage(new Long[]{1L, null, 2L, 2L, null, 2L, 2L, null}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{2L, 2L, null, 3L, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, null, TestApproximatePercentileAggregation.createPage(new Long[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{null}, new Long[]{1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)1L, TestApproximatePercentileAggregation.createPage(new Long[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{1L}, new Long[]{1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)2L, TestApproximatePercentileAggregation.createPage(new Long[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{1L, 2L, 3L}, new Long[]{1L, 1L, 1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)2L, TestApproximatePercentileAggregation.createPage(new Long[]{1L}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{2L, 3L}, new Long[]{1L, 1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateLongPercentileAggregations.LONG_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)3L, TestApproximatePercentileAggregation.createPage(new Long[]{1L, null, 2L, null, 2L, null}, new Long[]{1L, 1L, 2L, 1L, 2L, 1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Long[]{2L, null, 3L, null, 3L, null, 3L, 4L, 5L, 6L, 7L}, new Long[]{2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}, 0.5));
    }

    @Test
    public void testDoublePartialStep() throws Exception {
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, null, TestApproximatePercentileAggregation.createPage(new Double[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{null}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)1.0, TestApproximatePercentileAggregation.createPage(new Double[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{1.0}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)2.0, TestApproximatePercentileAggregation.createPage(new Double[]{null}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{1.0, 2.0, 3.0}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)2.0, TestApproximatePercentileAggregation.createPage(new Double[]{1.0}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{2.0, 3.0}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_AGGREGATION, 1.0, (Object)3.0, TestApproximatePercentileAggregation.createPage(new Double[]{1.0, null, 2.0, 2.0, null, 2.0, 2.0, null}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{2.0, 2.0, null, 3.0, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, null, TestApproximatePercentileAggregation.createPage(new Double[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{null}, new Long[]{1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)1.0, TestApproximatePercentileAggregation.createPage(new Double[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{1.0}, new Long[]{1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)2.0, TestApproximatePercentileAggregation.createPage(new Double[]{null}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{1.0, 2.0, 3.0}, new Long[]{1L, 1L, 1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)2.0, TestApproximatePercentileAggregation.createPage(new Double[]{1.0}, new Long[]{1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{2.0, 3.0}, new Long[]{1L, 1L}, 0.5));
        AggregationTestUtils.assertAggregation(ApproximateDoublePercentileAggregations.DOUBLE_APPROXIMATE_PERCENTILE_WEIGHTED_AGGREGATION, 1.0, (Object)3.0, TestApproximatePercentileAggregation.createPage(new Double[]{1.0, null, 2.0, null, 2.0, null}, new Long[]{1L, 1L, 2L, 1L, 2L, 1L}, 0.5), TestApproximatePercentileAggregation.createPage(new Double[]{2.0, null, 3.0, null, 3.0, null, 3.0, 4.0, 5.0, 6.0, 7.0}, new Long[]{2L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L}, 0.5));
    }

    private static Page createPage(Double[] values, double percentile) {
        Block percentilesBlock;
        Block valuesBlock;
        if (values.length == 0) {
            valuesBlock = EMPTY_DOUBLE_BLOCK;
            percentilesBlock = EMPTY_DOUBLE_BLOCK;
        } else {
            valuesBlock = BlockAssertions.createDoublesBlock(values);
            int positionCount = values.length;
            percentilesBlock = TestApproximatePercentileAggregation.createRLEBlock(percentile, positionCount);
        }
        return new Page(new Block[]{valuesBlock, percentilesBlock});
    }

    private static Page createPage(Long[] values, double percentile) {
        Block percentilesBlock;
        Block valuesBlock;
        if (values.length == 0) {
            valuesBlock = EMPTY_LONG_BLOCK;
            percentilesBlock = EMPTY_DOUBLE_BLOCK;
        } else {
            valuesBlock = BlockAssertions.createLongsBlock(values);
            percentilesBlock = TestApproximatePercentileAggregation.createRLEBlock(percentile, values.length);
        }
        return new Page(new Block[]{valuesBlock, percentilesBlock});
    }

    private static Page createPage(Long[] values, Long[] weights, double percentile) {
        Block percentilesBlock;
        Block weightsBlock;
        Block valuesBlock;
        Preconditions.checkArgument((values.length == weights.length ? 1 : 0) != 0, (Object)"values.length must match weights.length");
        if (values.length == 0) {
            valuesBlock = EMPTY_LONG_BLOCK;
            weightsBlock = EMPTY_LONG_BLOCK;
            percentilesBlock = EMPTY_DOUBLE_BLOCK;
        } else {
            valuesBlock = BlockAssertions.createLongsBlock(values);
            weightsBlock = BlockAssertions.createLongsBlock(weights);
            percentilesBlock = TestApproximatePercentileAggregation.createRLEBlock(percentile, values.length);
        }
        return new Page(new Block[]{valuesBlock, weightsBlock, percentilesBlock});
    }

    private static Page createPage(Double[] values, Long[] weights, double percentile) {
        Block percentilesBlock;
        Block weightsBlock;
        Block valuesBlock;
        Preconditions.checkArgument((values.length == weights.length ? 1 : 0) != 0, (Object)"values.length must match weights.length");
        if (values.length == 0) {
            valuesBlock = EMPTY_DOUBLE_BLOCK;
            weightsBlock = EMPTY_LONG_BLOCK;
            percentilesBlock = EMPTY_DOUBLE_BLOCK;
        } else {
            valuesBlock = BlockAssertions.createDoublesBlock(values);
            weightsBlock = BlockAssertions.createLongsBlock(weights);
            percentilesBlock = TestApproximatePercentileAggregation.createRLEBlock(percentile, values.length);
        }
        return new Page(new Block[]{valuesBlock, weightsBlock, percentilesBlock});
    }

    private static RunLengthEncodedBlock createRLEBlock(double percentile, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus());
        DoubleType.DOUBLE.writeDouble(blockBuilder, percentile);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }
}

