/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestBooleanMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < start + length; ++i) {
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 != 0);
        }
        return blockBuilder.build();
    }

    @Override
    public Boolean getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return length > 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"boolean");
    }
}

