/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.NullablePosition;
import com.facebook.presto.operator.aggregation.state.NullableBigintState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.BeforeClass;

public class TestCountNullAggregation
extends AbstractTestAggregationFunction {
    @BeforeClass
    public void setup() {
        InternalAggregationFunction function = new AggregationCompiler().generateAggregationFunction(CountNull.class);
        this.functionRegistry.addFunctions(new FunctionListBuilder((TypeManager)new TypeRegistry()).aggregate(function).getFunctions());
    }

    @Override
    public Block getSequenceBlock(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus());
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return blockBuilder.build();
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return 0L;
    }

    @Override
    public Object getExpectedValueIncludingNulls(int start, int length, int lengthIncludingNulls) {
        return (long)lengthIncludingNulls - (long)length;
    }

    @Override
    protected String getFunctionName() {
        return "count_null";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint");
    }

    @AggregationFunction(value="count_null")
    public static final class CountNull {
        private CountNull() {
        }

        @InputFunction
        public static void input(NullableBigintState state, @NullablePosition @SqlType(value="bigint") Block block, @BlockIndex int position) {
            if (block.isNull(position)) {
                state.setLong(state.getLong() + 1L);
            }
            state.setNull(false);
        }

        @CombineFunction
        public static void combine(NullableBigintState state, NullableBigintState scratchState) {
            state.setLong(state.getLong() + scratchState.getLong());
            state.setNull(state.isNull() && scratchState.isNull());
        }
    }
}

