/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDateTimeFunctions {
    private static final TimeZoneKey TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu");
    private static final DateTimeZone DATE_TIME_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)TIME_ZONE_KEY);
    private static final TimeZoneKey WEIRD_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"+07:09");
    private static final DateTimeZone WEIRD_ZONE = DateTimeZoneIndex.getDateTimeZone((TimeZoneKey)WEIRD_ZONE_KEY);
    private static final DateTime DATE = new DateTime(2001, 8, 22, 0, 0, 0, 0, DATE_TIME_ZONE);
    private static final String DATE_LITERAL = "DATE '2001-08-22'";
    private static final DateTime TIME = new DateTime(1970, 1, 1, 3, 4, 5, 321, DATE_TIME_ZONE);
    private static final String TIME_LITERAL = "TIME '03:04:05.321'";
    private static final DateTime WEIRD_TIME = new DateTime(1970, 1, 1, 3, 4, 5, 321, WEIRD_ZONE);
    private static final String WEIRD_TIME_LITERAL = "TIME '03:04:05.321 +07:09'";
    private static final DateTime TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, DATE_TIME_ZONE);
    private static final String TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321'";
    private static final DateTime WEIRD_TIMESTAMP = new DateTime(2001, 8, 22, 3, 4, 5, 321, WEIRD_ZONE);
    private static final String WEIRD_TIMESTAMP_LITERAL = "TIMESTAMP '2001-08-22 03:04:05.321 +07:09'";
    private static final TimeZoneKey WEIRD_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)429L);
    private Session session;
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.session = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(Locale.ENGLISH).build();
        this.functionAssertions = new FunctionAssertions(this.session);
    }

    @Test
    public void testCurrentDate() throws Exception {
        DateMidnight dateMidnight = new DateMidnight(this.session.getStartTime(), DateTimeZone.UTC).withZoneRetainFields(DATE_TIME_ZONE);
        this.assertFunction("CURRENT_DATE", this.toDate(dateMidnight.getMillis()));
    }

    @Test
    public void testLocalTime() throws Exception {
        long millis = new LocalTime(this.session.getStartTime(), DATE_TIME_ZONE).getMillisOfDay();
        this.functionAssertions.assertFunction("LOCALTIME", this.toTime(millis));
    }

    @Test
    public void testCurrentTime() throws Exception {
        long millis = new LocalTime(this.session.getStartTime(), DATE_TIME_ZONE).getMillisOfDay();
        this.functionAssertions.assertFunction("CURRENT_TIME", new SqlTimeWithTimeZone(millis, this.session.getTimeZoneKey()));
    }

    @Test
    public void testLocalTimestamp() {
        this.functionAssertions.assertFunction("localtimestamp", this.toTimestamp(this.session.getStartTime()));
    }

    @Test
    public void testCurrentTimestamp() {
        this.functionAssertions.assertFunction("current_timestamp", new SqlTimestampWithTimeZone(this.session.getStartTime(), this.session.getTimeZoneKey()));
        this.functionAssertions.assertFunction("now()", new SqlTimestampWithTimeZone(this.session.getStartTime(), this.session.getTimeZoneKey()));
    }

    @Test
    public void testFromUnixTime() {
        DateTime dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 0, DATE_TIME_ZONE);
        double seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", this.toTimestamp(dateTime));
        dateTime = new DateTime(2001, 1, 22, 3, 4, 5, 888, DATE_TIME_ZONE);
        seconds = (double)dateTime.getMillis() / 1000.0;
        this.assertFunction("from_unixtime(" + seconds + ")", this.toTimestamp(dateTime));
    }

    @Test
    public void testToUnixTime() {
        this.assertFunction("to_unixtime(TIMESTAMP '2001-08-22 03:04:05.321')", (double)TIMESTAMP.getMillis() / 1000.0);
        this.assertFunction("to_unixtime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", (double)WEIRD_TIMESTAMP.getMillis() / 1000.0);
    }

    @Test
    public void testTimeZone() {
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMinuteOfHour());
    }

    @Test
    public void testAtTimeZone() {
        this.functionAssertions.assertFunction("current_timestamp at time zone interval '07:09' hour to minute", new SqlTimestampWithTimeZone(this.session.getStartTime(), WEIRD_TIME_ZONE_KEY));
        this.functionAssertions.assertFunction("current_timestamp at time zone 'Asia/Oral'", new SqlTimestampWithTimeZone(this.session.getStartTime(), TimeZone.getTimeZone("Asia/Oral")));
        this.functionAssertions.assertFunction("now() at time zone 'Asia/Oral'", new SqlTimestampWithTimeZone(this.session.getStartTime(), TimeZone.getTimeZone("Asia/Oral")));
        this.functionAssertions.assertFunction("current_timestamp at time zone '+07:09'", new SqlTimestampWithTimeZone(this.session.getStartTime(), WEIRD_TIME_ZONE_KEY));
    }

    @Test
    public void testPartFunctions() {
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMonthOfYear() / 4 + 1);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getYear());
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321')", 5);
        this.assertFunction("timezone_hour(localtimestamp)", 5);
        this.assertFunction("timezone_hour(current_timestamp)", 5);
        this.assertFunction("second(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("day_of_week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("dow(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.dayOfWeek().get());
        this.assertFunction("day(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("day_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("doy(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.dayOfYear().get());
        this.assertFunction("week(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("week_of_year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.weekOfWeekyear().get());
        this.assertFunction("month(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("quarter(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMonthOfYear() / 4 + 1);
        this.assertFunction("year(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getYear());
        this.assertFunction("timezone_minute(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", 9);
        this.assertFunction("timezone_hour(TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", 7);
    }

    @Test
    public void testExtractFromTimestamp() {
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getMonthOfYear() / 4 + 1);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321')", TIMESTAMP.getYear());
        this.assertFunction("extract(second FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getSecondOfMinute());
        this.assertFunction("extract(minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMinuteOfHour());
        this.assertFunction("extract(hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getHourOfDay());
        this.assertFunction("extract(day_of_week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(dow FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfWeek());
        this.assertFunction("extract(day FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfMonth());
        this.assertFunction("extract(day_of_year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(doy FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getDayOfYear());
        this.assertFunction("extract(week FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getWeekOfWeekyear());
        this.assertFunction("extract(month FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMonthOfYear());
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getMonthOfYear() / 4 + 1);
        this.assertFunction("extract(year FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", WEIRD_TIMESTAMP.getYear());
        this.assertFunction("extract(timezone_minute FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", 9);
        this.assertFunction("extract(timezone_hour FROM TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", 7);
    }

    @Test
    public void testExtractFromTime() {
        this.assertFunction("extract(second FROM TIME '03:04:05.321')", 5);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321')", 4);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321')", 3);
        this.assertFunction("extract(second FROM TIME '03:04:05.321 +07:09')", 5);
        this.assertFunction("extract(minute FROM TIME '03:04:05.321 +07:09')", 4);
        this.assertFunction("extract(hour FROM TIME '03:04:05.321 +07:09')", 3);
    }

    @Test
    public void testExtractFromDate() {
        this.assertFunction("extract(day_of_week FROM DATE '2001-08-22')", 3);
        this.assertFunction("extract(dow FROM DATE '2001-08-22')", 3);
        this.assertFunction("extract(day FROM DATE '2001-08-22')", 22);
        this.assertFunction("extract(day_of_month FROM DATE '2001-08-22')", 22);
        this.assertFunction("extract(day_of_year FROM DATE '2001-08-22')", 234);
        this.assertFunction("extract(doy FROM DATE '2001-08-22')", 234);
        this.assertFunction("extract(week FROM DATE '2001-08-22')", 34);
        this.assertFunction("extract(month FROM DATE '2001-08-22')", 8);
        this.assertFunction("extract(quarter FROM DATE '2001-08-22')", 3);
        this.assertFunction("extract(year FROM DATE '2001-08-22')", 2001);
        this.assertFunction("extract(quarter FROM DATE '2001-01-01')", 1);
        this.assertFunction("extract(quarter FROM DATE '2001-03-31')", 1);
        this.assertFunction("extract(quarter FROM DATE '2001-04-01')", 2);
        this.assertFunction("extract(quarter FROM DATE '2001-06-30')", 2);
        this.assertFunction("extract(quarter FROM DATE '2001-07-01')", 3);
        this.assertFunction("extract(quarter FROM DATE '2001-09-30')", 3);
        this.assertFunction("extract(quarter FROM DATE '2001-10-01')", 4);
        this.assertFunction("extract(quarter FROM DATE '2001-12-31')", 4);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000')", 1);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999')", 1);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000')", 2);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999')", 2);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000')", 3);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999')", 3);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000')", 4);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999')", 4);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-01-01 00:00:00.000 +06:00')", 1);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-03-31 23:59:59.999 +06:00')", 1);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-04-01 00:00:00.000 +06:00')", 2);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-06-30 23:59:59.999 +06:00')", 2);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-07-01 00:00:00.000 +06:00')", 3);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-09-30 23:59:59.999 +06:00')", 3);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-10-01 00:00:00.000 +06:00')", 4);
        this.assertFunction("extract(quarter FROM TIMESTAMP '2001-12-31 23:59:59.999 +06:00')", 4);
    }

    @Test
    public void testExtractFromInterval() {
        this.assertFunction("extract(second FROM INTERVAL '5' SECOND)", 5);
        this.assertFunction("extract(second FROM INTERVAL '65' SECOND)", 5);
        this.assertFunction("extract(minute FROM INTERVAL '4' MINUTE)", 4);
        this.assertFunction("extract(minute FROM INTERVAL '64' MINUTE)", 4);
        this.assertFunction("extract(minute FROM INTERVAL '247' SECOND)", 4);
        this.assertFunction("extract(hour FROM INTERVAL '3' HOUR)", 3);
        this.assertFunction("extract(hour FROM INTERVAL '27' HOUR)", 3);
        this.assertFunction("extract(hour FROM INTERVAL '187' MINUTE)", 3);
        this.assertFunction("extract(day FROM INTERVAL '2' DAY)", 2);
        this.assertFunction("extract(day FROM INTERVAL '55' HOUR)", 2);
        this.assertFunction("extract(month FROM INTERVAL '3' MONTH)", 3);
        this.assertFunction("extract(month FROM INTERVAL '15' MONTH)", 3);
        this.assertFunction("extract(year FROM INTERVAL '2' YEAR)", 2);
        this.assertFunction("extract(year FROM INTERVAL '29' MONTH)", 2);
    }

    @Test
    public void testTruncateTimestamp() {
        DateTime result = TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(result));
        result = WEIRD_TIMESTAMP;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withHourOfDay(0);
        this.assertFunction("date_trunc('day', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(result));
    }

    @Test
    public void testTruncateTime() {
        DateTime result = TIME;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIME '03:04:05.321')", this.toTime(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIME '03:04:05.321')", this.toTime(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIME '03:04:05.321')", this.toTime(result));
        result = WEIRD_TIME;
        result = result.withMillisOfSecond(0);
        this.assertFunction("date_trunc('second', TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(result));
        result = result.withSecondOfMinute(0);
        this.assertFunction("date_trunc('minute', TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(result));
        result = result.withMinuteOfHour(0);
        this.assertFunction("date_trunc('hour', TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(result));
    }

    @Test
    public void testTruncateDate() {
        DateTime result = DATE;
        this.assertFunction("date_trunc('day', DATE '2001-08-22')", this.toDate(result));
        result = result.withDayOfMonth(20);
        this.assertFunction("date_trunc('week', DATE '2001-08-22')", this.toDate(result));
        result = result.withDayOfMonth(1);
        this.assertFunction("date_trunc('month', DATE '2001-08-22')", this.toDate(result));
        result = result.withMonthOfYear(7);
        this.assertFunction("date_trunc('quarter', DATE '2001-08-22')", this.toDate(result));
        result = result.withMonthOfYear(1);
        this.assertFunction("date_trunc('year', DATE '2001-08-22')", this.toDate(result));
    }

    @Test
    public void testAddFieldToTimestamp() {
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusHours(3)));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusDays(3)));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusMonths(9)));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321')", this.toTimestamp(TIMESTAMP.plusYears(3)));
        this.assertFunction("date_add('second', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusHours(3)));
        this.assertFunction("date_add('day', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusDays(3)));
        this.assertFunction("date_add('week', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusMonths(9)));
        this.assertFunction("date_add('year', 3, TIMESTAMP '2001-08-22 03:04:05.321 +07:09')", this.toTimestampWithTimeZone(WEIRD_TIMESTAMP.plusYears(3)));
    }

    @Test
    public void testAddFieldToDate() {
        this.assertFunction("date_add('day', 3, DATE '2001-08-22')", this.toDate(DATE.plusDays(3)));
        this.assertFunction("date_add('week', 3, DATE '2001-08-22')", this.toDate(DATE.plusWeeks(3)));
        this.assertFunction("date_add('month', 3, DATE '2001-08-22')", this.toDate(DATE.plusMonths(3)));
        this.assertFunction("date_add('quarter', 3, DATE '2001-08-22')", this.toDate(DATE.plusMonths(9)));
        this.assertFunction("date_add('year', 3, DATE '2001-08-22')", this.toDate(DATE.plusYears(3)));
    }

    @Test
    public void testAddFieldToTime() {
        this.assertFunction("date_add('second', 3, TIME '03:04:05.321')", this.toTime(TIME.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIME '03:04:05.321')", this.toTime(TIME.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIME '03:04:05.321')", this.toTime(TIME.plusHours(3)));
        this.assertFunction("date_add('second', 3, TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(WEIRD_TIME.plusSeconds(3)));
        this.assertFunction("date_add('minute', 3, TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(WEIRD_TIME.plusMinutes(3)));
        this.assertFunction("date_add('hour', 3, TIME '03:04:05.321 +07:09')", this.toTimeWithTimeZone(WEIRD_TIME.plusHours(3)));
    }

    @Test
    public void testDateDiffTimestamp() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, DATE_TIME_ZONE);
        String baseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678'";
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Seconds.secondsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Minutes.minutesBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Hours.hoursBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getMonths() / 3);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", " + TIMESTAMP_LITERAL + ")", Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIMESTAMP).getYears());
        DateTime weirdBaseDateTime = new DateTime(1960, 5, 3, 7, 2, 9, 678, WEIRD_ZONE);
        String weirdBaseDateTimeLiteral = "TIMESTAMP '1960-05-03 07:02:09.678 +07:09'";
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Seconds.secondsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getSeconds());
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Minutes.minutesBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMinutes());
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Hours.hoursBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getHours());
        this.assertFunction("date_diff('day', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Days.daysBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getDays());
        this.assertFunction("date_diff('week', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Weeks.weeksBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getWeeks());
        this.assertFunction("date_diff('month', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths());
        this.assertFunction("date_diff('quarter', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Months.monthsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getMonths() / 3);
        this.assertFunction("date_diff('year', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIMESTAMP_LITERAL + ")", Years.yearsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIMESTAMP).getYears());
    }

    @Test
    public void testDateDiffDate() {
        DateTime baseDateTime = new DateTime(1960, 5, 3, 0, 0, 0, 0, DATE_TIME_ZONE);
        String baseDateTimeLiteral = "DATE '1960-05-03'";
        this.assertFunction("date_diff('day', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", Days.daysBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getDays());
        this.assertFunction("date_diff('week', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", Weeks.weeksBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getWeeks());
        this.assertFunction("date_diff('month', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths());
        this.assertFunction("date_diff('quarter', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", Months.monthsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getMonths() / 3);
        this.assertFunction("date_diff('year', " + baseDateTimeLiteral + ", " + DATE_LITERAL + ")", Years.yearsBetween((ReadableInstant)baseDateTime, (ReadableInstant)DATE).getYears());
    }

    @Test
    public void testDateDiffTime() {
        DateTime baseDateTime = new DateTime(1970, 1, 1, 7, 2, 9, 678, DATE_TIME_ZONE);
        String baseDateTimeLiteral = "TIME '07:02:09.678'";
        this.assertFunction("date_diff('second', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", Seconds.secondsBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIME).getSeconds());
        this.assertFunction("date_diff('minute', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", Minutes.minutesBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIME).getMinutes());
        this.assertFunction("date_diff('hour', " + baseDateTimeLiteral + ", " + TIME_LITERAL + ")", Hours.hoursBetween((ReadableInstant)baseDateTime, (ReadableInstant)TIME).getHours());
        DateTime weirdBaseDateTime = new DateTime(1970, 1, 1, 7, 2, 9, 678, WEIRD_ZONE);
        String weirdBaseDateTimeLiteral = "TIME '07:02:09.678 +07:09'";
        this.assertFunction("date_diff('second', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", Seconds.secondsBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIME).getSeconds());
        this.assertFunction("date_diff('minute', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", Minutes.minutesBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIME).getMinutes());
        this.assertFunction("date_diff('hour', " + weirdBaseDateTimeLiteral + ", " + WEIRD_TIME_LITERAL + ")", Hours.hoursBetween((ReadableInstant)weirdBaseDateTime, (ReadableInstant)WEIRD_TIME).getHours());
    }

    @Test
    public void testParseDatetime() {
        this.assertFunction("parse_datetime('1960/01/22 03:04', 'YYYY/MM/DD HH:mm')", this.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("parse_datetime('1960/01/22 03:04 Asia/Oral', 'YYYY/MM/DD HH:mm ZZZZZ')", this.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forID((String)"Asia/Oral"))));
        this.assertFunction("parse_datetime('1960/01/22 03:04 +0500', 'YYYY/MM/DD HH:mm Z')", this.toTimestampWithTimeZone(new DateTime(1960, 1, 22, 3, 4, 0, 0, DateTimeZone.forOffsetHours((int)5))));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Both printing and parsing not supported")
    public void testInvalidDateParseFormat() {
        this.assertFunction("date_parse('%Y-%M-%d', '')", 0);
    }

    @Test
    public void testFormatDatetime() {
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm')", "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm ZZZZ')", "2001/08/22 03:04 Asia/Kathmandu");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm')", "2001/08/22 03:04");
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321 +07:09', 'YYYY/MM/dd HH:mm ZZZZ')", "2001/08/22 03:04 +07:09");
    }

    @Test
    public void testDateFormat() {
        String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", "Tue");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", "Jan");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%c')", "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%d')", "09");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%e')", "9");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%f')", "000321");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%H')", "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%h')", "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%I')", "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%i')", "04");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%j')", "009");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%k')", "13");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%l')", "1");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", "January");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%m')", "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", "PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", "01:04:05 PM");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%S')", "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%s')", "05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%T')", "13:04:05");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%v')", "02");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", "Tuesday");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%w')", "2");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%Y')", "2001");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%y')", "01");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%%')", "%");
        this.assertFunction("date_format(" + dateTimeLiteral + ", 'foo')", "foo");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%g')", "g");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%4')", "4");
        this.assertFunction("date_format(" + dateTimeLiteral + ", '%x %v')", "2001 02");
        String wierdDateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321 +07:09'";
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%a')", "Tue");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%b')", "Jan");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%c')", "1");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%d')", "09");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%e')", "9");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%f')", "000321");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%H')", "13");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%h')", "01");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%I')", "01");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%i')", "04");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%j')", "009");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%k')", "13");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%l')", "1");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%M')", "January");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%m')", "01");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%p')", "PM");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%r')", "01:04:05 PM");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%S')", "05");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%s')", "05");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%T')", "13:04:05");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%v')", "02");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%W')", "Tuesday");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%w')", "2");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%Y')", "2001");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%y')", "01");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%%')", "%");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", 'foo')", "foo");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%g')", "g");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%4')", "4");
        this.assertFunction("date_format(" + wierdDateTimeLiteral + ", '%x %v')", "2001 02");
    }

    @Test
    public void testDateParse() {
        this.assertFunction("date_parse('2013', '%Y')", this.toTimestamp(new DateTime(2013, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05', '%Y-%m')", this.toTimestamp(new DateTime(2013, 5, 1, 0, 0, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17', '%Y-%m-%d')", this.toTimestamp(new DateTime(2013, 5, 17, 0, 0, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17 12:35:10', '%Y-%m-%d %h:%i:%s')", this.toTimestamp(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17 12:35:10 PM', '%Y-%m-%d %h:%i:%s %p')", this.toTimestamp(new DateTime(2013, 5, 17, 12, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17 12:35:10 AM', '%Y-%m-%d %h:%i:%s %p')", this.toTimestamp(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17 00:35:10', '%Y-%m-%d %H:%i:%s')", this.toTimestamp(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013-05-17 23:35:10', '%Y-%m-%d %H:%i:%s')", this.toTimestamp(new DateTime(2013, 5, 17, 23, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('abc 2013-05-17 fff 23:35:10 xyz', 'abc %Y-%m-%d fff %H:%i:%s xyz')", this.toTimestamp(new DateTime(2013, 5, 17, 23, 35, 10, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('2013 14', '%Y %y')", this.toTimestamp(new DateTime(2014, 1, 1, 0, 0, 0, 0, DATE_TIME_ZONE)));
        this.assertFunction("date_parse('1998 53', '%x %v')", this.toTimestamp(new DateTime(1998, 12, 28, 0, 0, 0, 0, DATE_TIME_ZONE)));
    }

    @Test
    public void testLocale() {
        Locale locale = Locale.JAPANESE;
        Session localeSession = Session.builder().setUser("user").setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TIME_ZONE_KEY).setLocale(locale).build();
        FunctionAssertions localeAssertions = new FunctionAssertions(localeSession);
        String dateTimeLiteral = "TIMESTAMP '2001-01-09 13:04:05.321'";
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%a')", "\u706b");
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%W')", "\u706b\u66dc\u65e5");
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%p')", "\u5348\u5f8c");
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%r')", "01:04:05 \u5348\u5f8c");
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%b')", "1");
        localeAssertions.assertFunction("date_format(" + dateTimeLiteral + ", '%M')", "1\u6708");
        localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEE')", "\u706b");
        localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'EEEE')", "\u706b\u66dc\u65e5");
        localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'a')", "\u5348\u5f8c");
        localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMM')", "1");
        localeAssertions.assertFunction("format_datetime(" + dateTimeLiteral + ", 'MMMM')", "1\u6708");
        localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \u5348\u5f8c', '%Y-%m-%d %h:%i:%s %p')", this.toTimestamp(new DateTime(2013, 5, 17, 12, 35, 10, 0, DATE_TIME_ZONE), localeSession));
        localeAssertions.assertFunction("date_parse('2013-05-17 12:35:10 \u5348\u524d', '%Y-%m-%d %h:%i:%s %p')", this.toTimestamp(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE), localeSession));
        localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \u5348\u5f8c', 'yyyy-MM-dd hh:mm:ss a')", this.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 12, 35, 10, 0, DATE_TIME_ZONE)));
        localeAssertions.assertFunction("parse_datetime('2013-05-17 12:35:10 \u5348\u524d', 'yyyy-MM-dd hh:mm:ss aaa')", this.toTimestampWithTimeZone(new DateTime(2013, 5, 17, 0, 35, 10, 0, DATE_TIME_ZONE)));
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }

    private SqlDate toDate(long milliseconds) {
        return new SqlDate(milliseconds, this.session.getTimeZoneKey());
    }

    private SqlDate toDate(DateTime dateDate) {
        return new SqlDate(dateDate.getMillis(), this.session.getTimeZoneKey());
    }

    private SqlTime toTime(long milliseconds) {
        return new SqlTime(milliseconds, this.session.getTimeZoneKey());
    }

    private SqlTime toTime(DateTime dateTime) {
        return new SqlTime(dateTime.getMillis(), this.session.getTimeZoneKey());
    }

    private SqlTimeWithTimeZone toTimeWithTimeZone(DateTime dateTime) {
        return new SqlTimeWithTimeZone(dateTime.getMillis(), dateTime.getZone().toTimeZone());
    }

    private SqlTimestamp toTimestamp(long milliseconds) {
        return new SqlTimestamp(milliseconds, this.session.getTimeZoneKey());
    }

    private SqlTimestamp toTimestamp(DateTime dateTime) {
        return new SqlTimestamp(dateTime.getMillis(), this.session.getTimeZoneKey());
    }

    private SqlTimestamp toTimestamp(DateTime dateTime, Session session) {
        return new SqlTimestamp(dateTime.getMillis(), session.getTimeZoneKey());
    }

    private SqlTimestampWithTimeZone toTimestampWithTimeZone(DateTime dateTime) {
        return new SqlTimestampWithTimeZone(dateTime.getMillis(), dateTime.getZone().toTimeZone());
    }
}

