/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.PrestoException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestMathFunctions {
    private static final double[] DOUBLE_VALUES = new double[]{123.0, -123.0, 123.45, -123.45};
    private static final long[] longLefts = new long[]{9L, 10L, 11L, -9L, -10L, -11L};
    private static final long[] longRights = new long[]{3L, -3L};
    private static final double[] doubleLefts = new double[]{9.0, 10.0, 11.0, -9.0, -10.0, -11.0, 9.1, 10.1, 11.1, -9.1, -10.1, -11.1};
    private static final double[] doubleRights = new double[]{3.0, -3.0, 3.1, -3.1};
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testAbs() {
        this.assertFunction("abs(123)", 123L);
        this.assertFunction("abs(-123)", 123L);
        this.assertFunction("abs(123.0)", 123.0);
        this.assertFunction("abs(-123.0)", 123.0);
        this.assertFunction("abs(123.45)", 123.45);
        this.assertFunction("abs(-123.45)", 123.45);
    }

    @Test
    public void testAcos() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("acos(" + doubleValue + ")", Math.acos(doubleValue));
        }
    }

    @Test
    public void testAsin() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("asin(" + doubleValue + ")", Math.asin(doubleValue));
        }
    }

    @Test
    public void testAtan() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("atan(" + doubleValue + ")", Math.atan(doubleValue));
        }
    }

    @Test
    public void testAtan2() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("atan2(" + doubleValue + ", " + doubleValue + ")", Math.atan2(doubleValue, doubleValue));
        }
    }

    @Test
    public void testCbrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cbrt(" + doubleValue + ")", Math.cbrt(doubleValue));
        }
    }

    @Test
    public void testCeil() {
        this.assertFunction("ceil(123)", 123);
        this.assertFunction("ceil(-123)", -123);
        this.assertFunction("ceil(123.0)", 123.0);
        this.assertFunction("ceil(-123.0)", -123.0);
        this.assertFunction("ceil(123.45)", 124.0);
        this.assertFunction("ceil(-123.45)", -123.0);
        this.assertFunction("ceiling(123)", 123);
        this.assertFunction("ceiling(-123)", -123);
        this.assertFunction("ceiling(123.0)", 123.0);
        this.assertFunction("ceiling(-123.0)", -123.0);
        this.assertFunction("ceiling(123.45)", 124.0);
        this.assertFunction("ceiling(-123.45)", -123.0);
    }

    @Test
    public void testCos() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cos(" + doubleValue + ")", Math.cos(doubleValue));
        }
    }

    @Test
    public void testCosh() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("cosh(" + doubleValue + ")", Math.cosh(doubleValue));
        }
    }

    @Test
    public void testE() {
        this.assertFunction("e()", Math.E);
    }

    @Test
    public void testExp() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("exp(" + doubleValue + ")", Math.exp(doubleValue));
        }
    }

    @Test
    public void testFloor() {
        this.assertFunction("floor(123)", 123);
        this.assertFunction("floor(-123)", -123);
        this.assertFunction("floor(123.0)", 123.0);
        this.assertFunction("floor(-123.0)", -123.0);
        this.assertFunction("floor(123.45)", 123.0);
        this.assertFunction("floor(-123.45)", -124.0);
    }

    @Test
    public void testLn() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("ln(" + doubleValue + ")", Math.log(doubleValue));
        }
    }

    @Test
    public void testLog2() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("log2(" + doubleValue + ")", Math.log(doubleValue) / Math.log(2.0));
        }
    }

    @Test
    public void testLog10() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("log10(" + doubleValue + ")", Math.log10(doubleValue));
        }
    }

    @Test
    public void testLog() {
        for (double doubleValue : DOUBLE_VALUES) {
            for (double base : DOUBLE_VALUES) {
                this.assertFunction("log(" + doubleValue + ", " + base + ")", Math.log(doubleValue) / Math.log(base));
            }
        }
    }

    @Test
    public void testMod() {
        for (long left : longLefts) {
            for (long right : longRights) {
                this.assertFunction("mod(" + left + ", " + right + ")", left % right);
            }
        }
        for (long left : longLefts) {
            for (double right : doubleRights) {
                this.assertFunction("mod(" + left + ", " + right + ")", (double)left % right);
            }
        }
        for (double left : doubleLefts) {
            for (long right : longRights) {
                this.assertFunction("mod(" + left + ", " + right + ")", left % (double)right);
            }
        }
        for (double left : doubleLefts) {
            for (double right : doubleRights) {
                this.assertFunction("mod(" + left + ", " + right + ")", left % right);
            }
        }
    }

    @Test
    public void testPi() {
        this.assertFunction("pi()", Math.PI);
    }

    @Test
    public void testNaN() {
        this.assertFunction("nan()", Double.NaN);
        this.assertFunction("0.0 / 0.0", Double.NaN);
    }

    @Test
    public void testInfinity() {
        this.assertFunction("infinity()", Double.POSITIVE_INFINITY);
        this.assertFunction("-rand() / 0.0", Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testIsInfinite() {
        this.assertFunction("is_infinite(1.0 / 0.0)", true);
        this.assertFunction("is_infinite(0.0 / 0.0)", false);
        this.assertFunction("is_infinite(1.0 / 1.0)", false);
    }

    @Test
    public void testIsFinite() {
        this.assertFunction("is_finite(100000)", true);
        this.assertFunction("is_finite(rand() / 0.0)", false);
    }

    @Test
    public void testIsNaN() {
        this.assertFunction("is_nan(0.0 / 0.0)", true);
        this.assertFunction("is_nan(0.0 / 1.0)", false);
        this.assertFunction("is_nan(infinity() / infinity())", true);
        this.assertFunction("is_nan(nan())", true);
    }

    @Test
    public void testPow() {
        for (long left : longLefts) {
            for (long right : longRights) {
                this.assertFunction("pow(" + left + ", " + right + ")", Math.pow(left, right));
            }
        }
        for (long left : longLefts) {
            for (double right : doubleRights) {
                this.assertFunction("pow(" + left + ", " + right + ")", Math.pow(left, right));
            }
        }
        for (double left : doubleLefts) {
            for (long right : longRights) {
                this.assertFunction("pow(" + left + ", " + right + ")", Math.pow(left, right));
            }
        }
        for (double left : doubleLefts) {
            for (double right : doubleRights) {
                this.assertFunction("pow(" + left + ", " + right + ")", Math.pow(left, right));
            }
        }
    }

    @Test
    public void testRandom() {
        this.functionAssertions.tryEvaluateWithAll("rand()", SessionTestUtils.TEST_SESSION);
        this.functionAssertions.tryEvaluateWithAll("random()", SessionTestUtils.TEST_SESSION);
    }

    @Test
    public void testRound() {
        this.assertFunction("round( 3)", 3);
        this.assertFunction("round(-3)", -3);
        this.assertFunction("round( 3.0)", 3.0);
        this.assertFunction("round(-3.0)", -3.0);
        this.assertFunction("round( 3.499)", 3.0);
        this.assertFunction("round(-3.499)", -3.0);
        this.assertFunction("round( 3.5)", 4.0);
        this.assertFunction("round(-3.5)", -4.0);
        this.assertFunction("round(-3.5001)", -4.0);
        this.assertFunction("round(-3.99)", -4.0);
        this.assertFunction("round( 3, 0)", 3);
        this.assertFunction("round(-3, 0)", -3);
        this.assertFunction("round( 3.0, 0)", 3.0);
        this.assertFunction("round(-3.0, 0)", -3.0);
        this.assertFunction("round( 3.499, 0)", 3.0);
        this.assertFunction("round(-3.499, 0)", -3.0);
        this.assertFunction("round( 3.5, 0)", 4.0);
        this.assertFunction("round(-3.5, 0)", -4.0);
        this.assertFunction("round(-3.5001, 0)", -4.0);
        this.assertFunction("round(-3.99, 0)", -4.0);
        this.assertFunction("round( 3, 1)", 3);
        this.assertFunction("round(-3, 1)", -3);
        this.assertFunction("round( 3.0, 1)", 3.0);
        this.assertFunction("round(-3.0, 1)", -3.0);
        this.assertFunction("round( 3.499, 1)", 3.5);
        this.assertFunction("round(-3.499, 1)", -3.5);
        this.assertFunction("round( 3.5, 1)", 3.5);
        this.assertFunction("round(-3.5, 1)", -3.5);
        this.assertFunction("round(-3.5001, 1)", -3.5);
        this.assertFunction("round(-3.99, 1)", -4.0);
    }

    @Test
    public void testSin() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("sin(" + doubleValue + ")", Math.sin(doubleValue));
        }
    }

    @Test
    public void testSqrt() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("sqrt(" + doubleValue + ")", Math.sqrt(doubleValue));
        }
    }

    @Test
    public void testTan() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("tan(" + doubleValue + ")", Math.tan(doubleValue));
        }
    }

    @Test
    public void testTanh() {
        for (double doubleValue : DOUBLE_VALUES) {
            this.assertFunction("tanh(" + doubleValue + ")", Math.tanh(doubleValue));
        }
    }

    @Test
    public void testGreatest() throws Exception {
        this.assertFunction("greatest(1, 2)", 2);
        this.assertFunction("greatest(-1, -2)", -1);
        this.assertFunction("greatest(1.5, 2.3)", 2.3);
        this.assertFunction("greatest(-1.5, -2.3)", -1.5);
        this.assertFunction("greatest(1.5, 1.0 / 0.0)", Double.POSITIVE_INFINITY);
        this.assertFunction("greatest(1, 2.0)", 2.0);
        this.assertFunction("greatest(1.0, 2)", 2.0);
    }

    @Test
    public void testLeast() throws Exception {
        this.assertFunction("least(1, 2)", 1);
        this.assertFunction("least(-1, -2)", -2);
        this.assertFunction("least(1.5, 2.3)", 1.5);
        this.assertFunction("least(-1.5, -2.3)", -2.3);
        this.assertFunction("least(1.5, -1.0 / 0.0)", Double.NEGATIVE_INFINITY);
        this.assertFunction("least(1, 2.0)", 1.0);
        this.assertFunction("least(1.0, 2)", 1.0);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="\\QInvalid argument to greatest(): NaN\\E")
    public void testGreatestWithNaN() throws Exception {
        this.functionAssertions.tryEvaluate("greatest(1.5, 0.0 / 0.0)");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="\\QInvalid argument to least(): NaN\\E")
    public void testLeastWithNaN() throws Exception {
        this.functionAssertions.tryEvaluate("least(1.5, 0.0 / 0.0)");
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }
}

