/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.FunctionAssertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestRegexpFunctions {
    private FunctionAssertions functionAssertions;

    @BeforeClass
    public void setUp() {
        this.functionAssertions = new FunctionAssertions();
    }

    @Test
    public void testRegexpLike() {
        this.assertFunction("REGEXP_LIKE('Stephen', 'Ste(v|ph)en')", true);
        this.assertFunction("REGEXP_LIKE('Stevens', 'Ste(v|ph)en')", true);
        this.assertFunction("REGEXP_LIKE('Stephen', '^Ste(v|ph)en$')", true);
        this.assertFunction("REGEXP_LIKE('Stevens', '^Ste(v|ph)en$')", false);
        this.assertFunction("REGEXP_LIKE('hello world', '[a-z]')", true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-z]+$')", false);
        this.assertFunction("REGEXP_LIKE('Hello', '^(?i)[a-z]+$')", true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-zA-Z]+$')", true);
    }

    @Test
    public void testRegexpReplace() {
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]')", " .");
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]', '*')", "*** *****.");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})')", "call  now");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})', '($1) $2-$3')", "call (555) 123-4444 now");
    }

    @Test
    public void testRegexpExtract() {
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)')", "world");
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 1)", "orld");
    }

    private void assertFunction(String projection, Object expected) {
        this.functionAssertions.assertFunction(projection, expected);
    }
}

