/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.TaskSource;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class MockTaskManager
implements TaskManager {
    private final ScheduledExecutorService stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)"test-%d"));
    private final HttpServerInfo httpServerInfo;
    private final DataSize maxBufferSize;
    private final int initialPages;
    private final ConcurrentMap<TaskId, MockTask> tasks = new ConcurrentHashMap<TaskId, MockTask>();

    @Inject
    public MockTaskManager(HttpServerInfo httpServerInfo) {
        this(httpServerInfo, new DataSize(100.0, DataSize.Unit.MEGABYTE), 12);
    }

    public MockTaskManager(HttpServerInfo httpServerInfo, DataSize maxBufferSize, int initialPages) {
        Preconditions.checkNotNull((Object)httpServerInfo, (Object)"httpServerInfo is null");
        Preconditions.checkArgument((maxBufferSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"pageBufferMax must be at least 1");
        Preconditions.checkArgument((initialPages >= 0 ? 1 : 0) != 0, (Object)"initialPages is negative");
        Preconditions.checkArgument(((long)initialPages <= maxBufferSize.toBytes() ? 1 : 0) != 0, (Object)"initialPages is greater than maxBufferSize");
        this.httpServerInfo = httpServerInfo;
        this.maxBufferSize = maxBufferSize;
        this.initialPages = initialPages;
    }

    public synchronized List<TaskInfo> getAllTaskInfo() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MockTask task : this.tasks.values()) {
            builder.add((Object)task.getTaskInfo());
        }
        return builder.build();
    }

    public synchronized TaskInfo getTaskInfo(TaskId taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        MockTask task = (MockTask)this.tasks.get(taskId);
        if (task == null) {
            throw new NoSuchElementException();
        }
        return task.getTaskInfo();
    }

    public ListenableFuture<TaskInfo> getTaskInfo(TaskId taskId, TaskState currentState) {
        MockTask task = (MockTask)this.tasks.get(taskId);
        if (task == null) {
            throw new NoSuchElementException();
        }
        return Futures.immediateFuture((Object)task.getTaskInfo());
    }

    public synchronized TaskInfo updateTask(Session session, TaskId taskId, PlanFragment ignored, List<TaskSource> sources, OutputBuffers outputBuffers) {
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull(sources, (Object)"sources is null");
        Preconditions.checkNotNull((Object)outputBuffers, (Object)"outputBuffers is null");
        MockTask task = (MockTask)this.tasks.get(taskId);
        if (task == null) {
            task = new MockTask(session, taskId, HttpUriBuilder.uriBuilderFrom((URI)this.httpServerInfo.getHttpUri()).appendPath("v1/task").appendPath(taskId.toString()).build(), outputBuffers, this.maxBufferSize, this.initialPages, this.stateNotificationExecutor);
            this.tasks.put(taskId, task);
        }
        task.addOutputBuffers(outputBuffers);
        return task.getTaskInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<BufferResult> getTaskResults(TaskId taskId, TaskId outputId, long startingSequenceId, DataSize maxSize) {
        MockTask task;
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        MockTaskManager mockTaskManager = this;
        synchronized (mockTaskManager) {
            task = (MockTask)this.tasks.get(taskId);
        }
        if (task == null) {
            throw new NoSuchElementException();
        }
        return task.getResults(outputId, startingSequenceId, maxSize);
    }

    public synchronized TaskInfo abortTaskResults(TaskId taskId, TaskId outputId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        MockTask task = (MockTask)this.tasks.get(taskId);
        if (task == null) {
            throw new NoSuchElementException();
        }
        task.abortResults(outputId);
        return task.getTaskInfo();
    }

    public synchronized TaskInfo cancelTask(TaskId taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        MockTask task = (MockTask)this.tasks.get(taskId);
        if (task == null) {
            return null;
        }
        task.cancel();
        return task.getTaskInfo();
    }

    public static class MockTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final SharedBuffer sharedBuffer;

        public MockTask(Session session, TaskId taskId, URI location, OutputBuffers outputBuffers, DataSize maxBufferSize, int initialPages, ScheduledExecutorService stateNotificationExecutor) {
            this.taskStateMachine = new TaskStateMachine((TaskId)Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null"), (Executor)Preconditions.checkNotNull((Object)stateNotificationExecutor, (Object)"stateNotificationExecutor is null"));
            this.taskContext = new TaskContext(this.taskStateMachine, (Executor)stateNotificationExecutor, session, new DataSize(256.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true, true);
            this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
            this.sharedBuffer = new SharedBuffer(taskId, (Executor)stateNotificationExecutor, (DataSize)Preconditions.checkNotNull((Object)maxBufferSize, (Object)"maxBufferSize is null"));
            this.sharedBuffer.setOutputBuffers(outputBuffers);
            ImmutableList data = ImmutableList.of((Object)"apple", (Object)"banana", (Object)"cherry", (Object)"date");
            for (int i = 0; i < initialPages; ++i) {
                Preconditions.checkState((boolean)this.sharedBuffer.enqueue(new Page(new Block[]{BlockAssertions.createStringsBlock(Iterables.concat(Collections.nCopies(i + 1, data)))})).isDone(), (Object)"Unable to add page to buffer");
            }
            this.sharedBuffer.setNoMorePages();
        }

        public void abortResults(TaskId outputId) {
            this.sharedBuffer.abort(outputId);
        }

        public void addOutputBuffers(OutputBuffers outputBuffers) {
            this.sharedBuffer.setOutputBuffers(outputBuffers);
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public ListenableFuture<BufferResult> getResults(TaskId outputId, long startingSequenceId, DataSize maxSize) {
            return this.sharedBuffer.get(outputId, startingSequenceId, maxSize);
        }

        public TaskInfo getTaskInfo() {
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Iterable)this.taskStateMachine.getFailureCauses());
            }
            return new TaskInfo(this.taskStateMachine.getTaskId(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, DateTime.now(), this.sharedBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), (List)failures);
        }
    }
}

