/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.type.LikeFunctions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.joni.Regex;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLikeFunctions {
    @Test
    public void testLikeBasic() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"f%b__"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"foobar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineInPattern() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%o\nbar"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineBeforeMatch() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test
    public void testLikeNewlineInMatch() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"f%b%"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"foo\nbar"), (Regex)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeUtf8Pattern() {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%\u540d\u8a89%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertFalse((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"foo"), (Regex)regex));
    }

    @Test(timeOut=1000L)
    public void testLikeInvalidUtf8Value() {
        Slice value = Slices.wrappedBuffer((byte[])new byte[]{97, 98, 99, -1, 120, 121});
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"%b%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)value, (Regex)regex));
    }

    @Test
    public void testBackslashesNoSpecialTreatment() throws Exception {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"\\abc\\/\\\\"), (Regex)regex));
    }

    @Test
    public void testSelfEscaping() throws Exception {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"\\\\abc\\%"), (Slice)Slices.utf8Slice((String)"\\"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"\\abc%"), (Regex)regex));
    }

    @Test
    public void testAlternateEscapedCharacters() throws Exception {
        Regex regex = LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)"xxx%x_xabcxx"), (Slice)Slices.utf8Slice((String)"x"));
        Assert.assertTrue((boolean)LikeFunctions.like((Slice)Slices.utf8Slice((String)"x%_abcx"), (Regex)regex));
    }
}

