/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import java.util.Map;
import org.testng.annotations.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setExperimentalSyntaxEnabled(false).setDistributedIndexJoinsEnabled(false).setDistributedJoinsEnabled(false).setOptimizeMetadataQueries(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap propertiesLegacy = new ImmutableMap.Builder().put((Object)"analyzer.experimental-syntax-enabled", (Object)"true").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"distributed-joins-enabled", (Object)"true").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").build();
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"experimental-syntax-enabled", (Object)"true").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"distributed-joins-enabled", (Object)"true").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").build();
        FeaturesConfig expected = new FeaturesConfig().setExperimentalSyntaxEnabled(true).setDistributedIndexJoinsEnabled(true).setDistributedJoinsEnabled(true).setOptimizeMetadataQueries(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        ConfigAssertions.assertDeprecatedEquivalence(FeaturesConfig.class, (Map)properties, (Map[])new Map[]{propertiesLegacy});
    }
}

